/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.rabbit.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;
import vip.justlive.rabbit.consumer.ConsumerDef;
import vip.justlive.rabbit.producer.QueueProperties;

public class CustomMessageConverter
extends AbstractMessageConverter
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Object fromMessage(Message message) {
        MessageProperties prop = message.getMessageProperties();
        ConsumerDef consumer = ConsumerDef.lookup(prop.getConsumerQueue(), prop.getReceivedExchange(), prop.getReceivedRoutingKey());
        if (consumer == null) {
            return message.getBody();
        }
        if (this.applicationContext != null && StringUtils.hasText((String)consumer.getQueueProperties().getMessageConverter())) {
            return ((MessageConverter)this.applicationContext.getBean(consumer.getQueueProperties().getMessageConverter(), MessageConverter.class)).fromMessage(message);
        }
        Object msg = message.getBody();
        Type type = consumer.getType();
        if (type != byte[].class) {
            msg = JSON.parseObject((byte[])msg, (Type)type, (Feature[])new Feature[0]);
        }
        return msg;
    }

    protected Message createMessage(Object object, MessageProperties props) {
        byte[] bytes;
        QueueProperties queueProperties = QueueProperties.get();
        if (this.applicationContext != null && queueProperties != null && StringUtils.hasText((String)queueProperties.getMessageConverter())) {
            return ((MessageConverter)this.applicationContext.getBean(queueProperties.getMessageConverter(), MessageConverter.class)).toMessage(object, props);
        }
        if (object instanceof byte[]) {
            bytes = (byte[])object;
            props.setContentType("application/octet-stream");
        } else {
            bytes = JSON.toJSONBytes((Object)object, (SerializerFeature[])new SerializerFeature[0]);
            props.setContentType("application/x-java-serialized-object");
        }
        props.setContentLength((long)bytes.length);
        return new Message(bytes, props);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

