/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.rabbit.producer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.core.env.Environment;
import vip.justlive.rabbit.annotation.Rqueue;
import vip.justlive.rabbit.producer.BaseProducer;
import vip.justlive.rabbit.producer.QueueProperties;

public class ProducerProxy<T>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(ProducerProxy.class);
    private final boolean exchangeMode;
    private final RabbitTemplate template;
    private final QueueProperties queueProperties;

    ProducerProxy(Class<T> clazz, RabbitTemplate template, Environment environment) {
        Rqueue rqueue = clazz.getAnnotation(Rqueue.class);
        if (rqueue == null) {
            throw new IllegalArgumentException("BaseProducer \u63a5\u53e3\u9700\u8981 @Rqueue");
        }
        String queue = environment.resolvePlaceholders(rqueue.queue());
        String exchange = environment.resolvePlaceholders(rqueue.exchange());
        String routing = environment.resolvePlaceholders(rqueue.routing());
        String messageConverter = environment.resolvePlaceholders(rqueue.messageConverter());
        this.queueProperties = new QueueProperties(queue, exchange, routing, messageConverter);
        this.exchangeMode = exchange.length() > 0;
        this.template = template;
        log.info("created producer proxy for queue [{}][{}][{}]", new Object[]{queue, exchange, routing});
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!BaseProducer.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        QueueProperties.set(this.queueProperties);
        if (this.exchangeMode) {
            this.template.convertAndSend(this.queueProperties.getExchange(), this.queueProperties.getRouting(), args[0], (MessagePostProcessor)this.queueProperties);
        } else {
            this.template.convertAndSend(this.queueProperties.getRouting(), args[0], (MessagePostProcessor)this.queueProperties);
        }
        return null;
    }
}

