/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.rabbit.producer;

import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import vip.justlive.rabbit.annotation.RqueueScan;
import vip.justlive.rabbit.producer.ProducerScanner;

public class ProducerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(ProducerRegistrar.class);
    private ResourceLoader resourceLoader;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(RqueueScan.class.getName()));
        if (attributes == null) {
            log.warn("No @RqueueScan was found");
            return;
        }
        String[] basePackages = attributes.getStringArray("value");
        String basePackage = metadata.getClassName().substring(0, metadata.getClassName().lastIndexOf("."));
        if (basePackages.length == 0) {
            basePackages = new String[]{basePackage};
        } else {
            basePackages = Arrays.copyOf(basePackages, basePackages.length + 1);
            basePackages[basePackages.length - 1] = basePackage;
        }
        ProducerScanner scanner = new ProducerScanner(registry);
        scanner.setResourceLoader(this.resourceLoader);
        scanner.scan(basePackages);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

