/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.rabbit.producer;

import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import vip.justlive.rabbit.annotation.Rqueue;
import vip.justlive.rabbit.producer.ProducerFactoryBean;

public class ProducerScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger log = LoggerFactory.getLogger(ProducerScanner.class);

    ProducerScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Rqueue.class));
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            log.warn("No Producer was found in '{}' package. Please check your configuration.", (Object)Arrays.toString(basePackages));
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            if (beanClassName == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("creating ProducerFactoryBean with name '{}' and '{}' interface", (Object)holder.getBeanName(), (Object)beanClassName);
            }
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)beanClassName);
            definition.setBeanClass(ProducerFactoryBean.class);
            definition.setAutowireMode(2);
        }
    }
}

