/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.client;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.base.ClassUtils;
import vip.justlive.oxygen.core.util.base.MoreObjects;
import vip.justlive.oxygen.core.util.base.Pair;
import vip.justlive.supine.client.Reference;
import vip.justlive.supine.client.ReferenceProxy;
import vip.justlive.supine.common.ClientConfig;
import vip.justlive.supine.registry.LocalRegistry;
import vip.justlive.supine.registry.MulticastRegistry;
import vip.justlive.supine.registry.Registry;

public class ReferenceFactory {
    private static final Map<Pair<Class<?>, String>, Object> PROXIES = new HashMap(4);
    private final ClientConfig config;
    private final Registry registry;
    private volatile boolean state;

    public ReferenceFactory(ClientConfig config) {
        this(config, ReferenceFactory.select(config));
    }

    public ReferenceFactory(ClientConfig config, Registry registry) {
        this.config = config;
        this.registry = registry;
    }

    private static Registry select(ClientConfig config) {
        if (config.getRegistryType() == 1) {
            return new MulticastRegistry(config);
        }
        if (config.getRegistryAddress() == null || config.getRegistryAddress().trim().isEmpty()) {
            throw Exceptions.fail((String)"[registryAddress]\u4e0d\u6b63\u786e");
        }
        return new LocalRegistry(config);
    }

    public <T> T create(Class<T> referenceType) {
        MoreObjects.notNull(referenceType, (String)"[referenceType]\u4e0d\u80fd\u4e3a\u7a7a");
        if (!referenceType.isInterface()) {
            throw Exceptions.fail((String)String.format("[%s]\u4e0d\u662f\u63a5\u53e3\u7c7b\u578b", referenceType));
        }
        Reference reference = (Reference)ClassUtils.getAnnotation(referenceType, Reference.class);
        if (reference != null) {
            return this.create(referenceType, reference.version());
        }
        return this.create(referenceType, "");
    }

    public <T> T create(Class<T> referenceType, String version) {
        Pair pair = new Pair().setKey(referenceType).setValue((Object)version);
        Object bean = PROXIES.get(pair);
        if (bean != null) {
            return referenceType.cast(bean);
        }
        T obj = referenceType.cast(Proxy.newProxyInstance(referenceType.getClassLoader(), new Class[]{referenceType}, (InvocationHandler)new ReferenceProxy(this.config, this.registry, version)));
        PROXIES.put(pair, obj);
        return obj;
    }

    public void start() throws IOException {
        if (this.state) {
            return;
        }
        this.state = true;
        if (this.registry != null) {
            this.registry.start();
        }
    }

    public void stop() {
        if (!this.state) {
            return;
        }
        this.state = false;
        PROXIES.clear();
        if (this.registry != null) {
            this.registry.stop();
        }
    }
}

