/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.util.base.SnowflakeId;
import vip.justlive.supine.common.ClientConfig;
import vip.justlive.supine.common.Request;
import vip.justlive.supine.common.RequestKey;
import vip.justlive.supine.common.ResultFuture;
import vip.justlive.supine.registry.Registry;
import vip.justlive.supine.transport.ClientTransport;

public class ReferenceProxy
implements InvocationHandler {
    private final ClientConfig config;
    private final Registry registry;
    private final String version;
    private final Map<Method, RequestKey> keys = new ConcurrentHashMap<Method, RequestKey>(4);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        Request request = new Request().setId(SnowflakeId.defaultNextId()).setArgs(args);
        RequestKey key = this.keys.computeIfAbsent(method, k -> new RequestKey(this.version, k.getDeclaringClass().getName(), k.getName(), k.getParameterTypes()));
        ClientTransport transport = this.registry.discovery(key);
        request.setMid(transport.lookup(key));
        ResultFuture resultFuture = new ResultFuture(method.getReturnType());
        if (this.config.isAsync()) {
            return this.async(request, resultFuture, transport);
        }
        return this.sync(request, resultFuture, transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sync(Request request, ResultFuture<?> resultFuture, ClientTransport transport) throws Throwable {
        ResultFuture.add(request.getId(), resultFuture);
        try {
            transport.send(request);
            Object obj = resultFuture.get(this.config.getTimeout(), TimeUnit.SECONDS);
            return obj;
        }
        finally {
            ResultFuture.remove(request.getId());
        }
    }

    private Object async(Request request, ResultFuture<?> resultFuture, ClientTransport transport) {
        ResultFuture.add(request.getId(), resultFuture);
        resultFuture.local();
        try {
            transport.send(request);
        }
        catch (Exception e) {
            ResultFuture.future();
            throw e;
        }
        return null;
    }

    public ReferenceProxy(ClientConfig config, Registry registry, String version) {
        this.config = config;
        this.registry = registry;
        this.version = version;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<Method, RequestKey> getKeys() {
        return this.keys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceProxy)) {
            return false;
        }
        ReferenceProxy other = (ReferenceProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClientConfig this$config = this.getConfig();
        ClientConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Registry this$registry = this.getRegistry();
        Registry other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<Method, RequestKey> this$keys = this.getKeys();
        Map<Method, RequestKey> other$keys = other.getKeys();
        return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReferenceProxy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Registry $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<Method, RequestKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        return result;
    }

    public String toString() {
        return "ReferenceProxy(config=" + this.getConfig() + ", registry=" + this.getRegistry() + ", version=" + this.getVersion() + ", keys=" + this.getKeys() + ")";
    }
}

