/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicInteger IDS = new AtomicInteger(0);
    private int id;
    private final String version;
    private final String className;
    private final String methodName;
    private final Class<?>[] types;

    public RequestKey mark() {
        this.id = IDS.getAndIncrement();
        return this;
    }

    public int hashCode() {
        return Objects.hashCode(this.version) + Objects.hashCode(this.className) + Objects.hashCode(this.methodName) + Arrays.hashCode(this.types);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RequestKey)) {
            return false;
        }
        RequestKey other = (RequestKey)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.className, other.className) && Objects.equals(this.methodName, other.methodName) && Arrays.equals(this.types, other.types);
    }

    public String toString() {
        return "RequestKey(id=" + this.getId() + ", version=" + this.version + ", className=" + this.className + ", methodName=" + this.methodName + ", types=" + Arrays.deepToString(this.types) + ")";
    }

    public RequestKey(String version, String className, String methodName, Class<?>[] types) {
        this.version = version;
        this.className = className;
        this.methodName = methodName;
        this.types = types;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

