/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.common;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import vip.justlive.supine.common.Response;

public class ResultFuture<T> {
    private static final Map<Long, ResultFuture<?>> FUTURES = new ConcurrentHashMap();
    private static final ThreadLocal<ResultFuture<?>> LOCAL = new ThreadLocal();
    private final Class<T> type;
    private final CompletableFuture<Response> future;
    private Consumer<T> onSuccess;
    private Consumer<Throwable> onFailure;

    public ResultFuture(Class<T> type) {
        this.type = type;
        this.future = new CompletableFuture();
    }

    public static void add(Long id, ResultFuture<?> future) {
        FUTURES.put(id, future);
    }

    public static void complete(Response response) {
        ResultFuture<?> future = FUTURES.get(response.getId());
        if (future != null) {
            try {
                super.completeFuture(response);
            }
            finally {
                ResultFuture.remove(response.getId());
            }
        }
    }

    public static void remove(Long id) {
        FUTURES.remove(id);
    }

    public static <T> ResultFuture<T> future() {
        try {
            ResultFuture<?> resultFuture = LOCAL.get();
            return resultFuture;
        }
        finally {
            LOCAL.remove();
        }
    }

    public void local() {
        LOCAL.set(this);
    }

    public T get() throws Throwable {
        Response response = this.future.join();
        if (response.hasError()) {
            throw response.getException();
        }
        return this.cast(response.getResult());
    }

    public T get(long timeout, TimeUnit unit) throws Throwable {
        Response response = this.future.get(timeout, unit);
        if (response.hasError()) {
            throw response.getException();
        }
        return this.cast(response.getResult());
    }

    private void completeFuture(Response response) {
        this.future.complete(response);
        if (this.onFailure != null && response.hasError()) {
            this.onFailure.accept(response.getException());
        }
        if (this.onSuccess != null && !response.hasError()) {
            this.onSuccess.accept(this.cast(response.getResult()));
        }
    }

    private T cast(Object result) {
        return (T)result;
    }

    public Class<T> getType() {
        return this.type;
    }

    public ResultFuture<T> setOnSuccess(Consumer<T> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public ResultFuture<T> setOnFailure(Consumer<Throwable> onFailure) {
        this.onFailure = onFailure;
        return this;
    }
}

