/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.registry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.base.ExpiringMap;
import vip.justlive.oxygen.core.util.net.aio.AioHandler;
import vip.justlive.oxygen.core.util.net.aio.Client;
import vip.justlive.oxygen.core.util.net.aio.GroupContext;
import vip.justlive.supine.codec.Serializer;
import vip.justlive.supine.common.ClientConfig;
import vip.justlive.supine.common.RequestKey;
import vip.justlive.supine.registry.Registry;
import vip.justlive.supine.transport.ClientTransport;
import vip.justlive.supine.transport.impl.AioClientTransport;
import vip.justlive.supine.transport.impl.ClientHandler;

public abstract class AbstractRegistry
implements Registry {
    private static final Logger log = LoggerFactory.getLogger(AbstractRegistry.class);
    private static final Random RANDOM = new Random();
    protected Serializer serializer;
    private ExpiringMap<InetSocketAddress, ClientTransport> transports;
    private Client client;

    @Override
    public void start() throws IOException {
        GroupContext groupContext = new GroupContext((AioHandler)new ClientHandler(this.serializer));
        groupContext.setDaemon(true);
        this.client = new Client(groupContext);
    }

    @Override
    public void stop() {
        if (this.client != null) {
            this.client.close();
        }
    }

    void init(ClientConfig config) {
        this.transports = ExpiringMap.builder().expiration((long)config.getIdleTimeout(), TimeUnit.SECONDS).expiringPolicy(ExpiringMap.ExpiringPolicy.ACCESSED).scheduleDelay(config.getIdleTimeout()).asyncExpiredListeners(this::expired).build();
    }

    ClientTransport load(List<InetSocketAddress> addresses, RequestKey key) {
        int size = addresses.size();
        int index = RANDOM.nextInt(size);
        AtomicReference<Exception> reference = new AtomicReference<Exception>();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress address = addresses.get(index);
            ClientTransport transport = this.get(address, reference);
            index = (index + 1) % addresses.size();
            if (transport == null || transport.isClosed() || transport.lookup(key) == null) continue;
            return transport;
        }
        if (reference.get() != null) {
            throw Exceptions.wrap((Throwable)((Throwable)reference.get()));
        }
        throw Exceptions.fail((String)"\u8fdc\u7a0b\u670d\u52a1\u4e0d\u53ef\u7528");
    }

    private synchronized ClientTransport get(InetSocketAddress address, AtomicReference<Exception> reference) {
        ClientTransport transport = (ClientTransport)this.transports.get((Object)address);
        if (transport != null && !transport.isClosed()) {
            return transport;
        }
        transport = new AioClientTransport(this.client, this.serializer);
        try {
            transport.connect(address);
            this.transports.put((Object)address, (Object)transport);
            return transport;
        }
        catch (Exception e) {
            log.warn("\u5ba2\u6237\u7aef\u8fde\u63a5[{}]\u670d\u52a1\u5931\u8d25", (Object)address, (Object)e);
            reference.set(e);
            return null;
        }
    }

    private void expired(InetSocketAddress address, ClientTransport transport, ExpiringMap.RemovalCause cause) {
        if (log.isDebugEnabled()) {
            log.debug("[{}]\u8fde\u63a5\u5931\u6548[{}]\uff0c\u5173\u95ed\u8fde\u63a5", (Object)cause, (Object)address);
        }
        transport.close();
    }
}

