/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.registry;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.base.ExpiringMap;
import vip.justlive.oxygen.core.util.base.MoreObjects;
import vip.justlive.oxygen.core.util.base.SystemUtils;
import vip.justlive.oxygen.core.util.concurrent.ThreadUtils;
import vip.justlive.supine.codec.KryoSerializer;
import vip.justlive.supine.codec.Serializer;
import vip.justlive.supine.common.ClientConfig;
import vip.justlive.supine.common.RegistryInfo;
import vip.justlive.supine.common.RequestKey;
import vip.justlive.supine.common.ServiceConfig;
import vip.justlive.supine.registry.AbstractRegistry;
import vip.justlive.supine.transport.ClientTransport;

public class MulticastRegistry
extends AbstractRegistry {
    private static final Logger log = LoggerFactory.getLogger(MulticastRegistry.class);
    private static final int BUFFER_SIZE = 65536;
    private static final long INTERVAL = 10000L;
    private final RegistryInfo registryInfo = new RegistryInfo().setKeys(new LinkedList<RequestKey>());
    private final ServiceConfig serviceConfig;
    private final ClientConfig clientConfig;
    private MulticastSocket socket;
    private DatagramPacket packet;
    private volatile boolean stopped;
    private ScheduledExecutorService schedule;
    private ExpiringMap<InetSocketAddress, List<RequestKey>> services;
    private Map<RequestKey, List<InetSocketAddress>> requestToService;
    private long lastUpdated;
    private InetSocketAddress registryAddress;

    public MulticastRegistry(ServiceConfig config) {
        this.serviceConfig = config;
        this.clientConfig = null;
        this.serializer = (Serializer)MoreObjects.firstNonNull((Object)config.getSerializer(), (Object)KryoSerializer.INSTANCE, (Object[])new Serializer[0]);
    }

    public MulticastRegistry(ClientConfig config) {
        this.serviceConfig = null;
        this.clientConfig = config;
        this.serializer = (Serializer)MoreObjects.firstNonNull((Object)config.getSerializer(), (Object)KryoSerializer.INSTANCE, (Object[])new Serializer[0]);
        this.services = ExpiringMap.builder().expiration(20000L, TimeUnit.MILLISECONDS).build();
        this.requestToService = new HashMap<RequestKey, List<InetSocketAddress>>(2);
        super.init(config);
    }

    @Override
    public void register(List<RequestKey> keys) {
        this.registryInfo.getKeys().addAll(keys);
        if (this.packet != null) {
            byte[] data = this.serializer.encode(this.registryInfo);
            this.packet = new DatagramPacket(data, data.length, this.registryAddress);
        }
    }

    @Override
    public void unregister(List<RequestKey> keys) {
        this.registryInfo.getKeys().removeAll(keys);
        if (this.packet != null) {
            byte[] data = this.serializer.encode(this.registryInfo);
            this.packet = new DatagramPacket(data, data.length, this.registryAddress);
        }
    }

    @Override
    public void start() throws IOException {
        super.start();
        this.schedule = ThreadUtils.newScheduledExecutor((int)1, (String)"registry");
        if (this.serviceConfig != null) {
            this.service(this.serviceConfig);
        } else if (this.clientConfig != null) {
            this.client(this.clientConfig);
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.registryInfo.getKeys().clear();
        if (this.schedule != null) {
            this.schedule.shutdown();
        }
        super.stop();
    }

    @Override
    public ClientTransport discovery(RequestKey key) {
        List<InetSocketAddress> addresses = this.requestToService.get(key);
        if (addresses == null) {
            throw Exceptions.fail((String)"\u6ca1\u6709\u53ef\u7528\u7684\u670d\u52a1\u63d0\u4f9b\u8005");
        }
        return this.load(addresses, key);
    }

    private void client(ClientConfig clientConfig) throws IOException {
        String address = clientConfig.getRegistryAddress();
        if (address == null || address.trim().length() == 0) {
            address = "234.69.69.69:56969";
        }
        InetSocketAddress bindAddress = SystemUtils.parseAddress((String)address);
        this.socket = new MulticastSocket(bindAddress.getPort());
        this.socket.setReuseAddress(true);
        this.socket.setReceiveBufferSize(65536);
        this.socket.setSoTimeout(10000);
        this.socket.joinGroup(bindAddress.getAddress());
        this.packet = new DatagramPacket(new byte[65536], 65536);
        this.stopped = false;
        this.schedule.execute(new Receiver());
    }

    private void service(ServiceConfig config) throws IOException {
        this.socket = new MulticastSocket();
        this.socket.setReuseAddress(true);
        this.socket.setTimeToLive(255);
        this.socket.setSendBufferSize(65536);
        this.registryInfo.setHost(config.getHost()).setPort(config.getPort());
        this.registryAddress = config.getRegistryAddress() == null || config.getRegistryAddress().trim().length() == 0 ? SystemUtils.parseAddress((String)"234.69.69.69:56969") : SystemUtils.parseAddress((String)config.getRegistryAddress());
        byte[] data = this.serializer.encode(this.registryInfo);
        this.packet = new DatagramPacket(data, data.length, this.registryAddress);
        this.stopped = false;
        this.schedule.execute(new Sender());
    }

    private class Receiver
    implements Runnable {
        private Receiver() {
        }

        @Override
        public void run() {
            while (!MulticastRegistry.this.stopped) {
                try {
                    MulticastRegistry.this.socket.receive(MulticastRegistry.this.packet);
                    this.handleReceive();
                }
                catch (IOException iOException) {}
            }
        }

        private void handleReceive() {
            if (MulticastRegistry.this.packet == null) {
                return;
            }
            byte[] data = MulticastRegistry.this.packet.getData();
            RegistryInfo info = (RegistryInfo)MulticastRegistry.this.serializer.decode(data);
            if (log.isDebugEnabled()) {
                log.debug("\u6ce8\u518c\u4e2d\u5fc3\u83b7\u53d6\u5230\u4e00\u4e2a\u670d\u52a1\u5730\u5740 -> [{}:{}]", (Object)info.getHost(), (Object)info.getPort());
            }
            if (info.getKeys() == null || info.getKeys().isEmpty()) {
                return;
            }
            InetSocketAddress address = new InetSocketAddress(info.getHost(), info.getPort());
            MulticastRegistry.this.services.put((Object)address, info.getKeys());
            long curr = System.currentTimeMillis();
            if (curr - MulticastRegistry.this.lastUpdated < 10000L) {
                return;
            }
            MulticastRegistry.this.lastUpdated = curr;
            HashMap map = new HashMap(2);
            MulticastRegistry.this.services.forEach((k, v) -> v.forEach(item -> map.computeIfAbsent(item, rk -> new ArrayList()).add(k)));
            MulticastRegistry.this.requestToService = map;
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        @Override
        public void run() {
            if (MulticastRegistry.this.serviceConfig == null || MulticastRegistry.this.stopped || MulticastRegistry.this.socket == null || MulticastRegistry.this.packet == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.info("[{}]\u5f00\u59cb\u6ce8\u518c\u670d\u52a1\uff0c[{}]\u4e2a\u8c03\u7528\u65b9\u6cd5", (Object)MulticastRegistry.this.registryAddress, (Object)MulticastRegistry.this.registryInfo.getKeys().size());
            }
            try {
                MulticastRegistry.this.socket.send(MulticastRegistry.this.packet);
            }
            catch (IOException e) {
                log.warn("multicast\u6ce8\u518c\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
            }
            if (MulticastRegistry.this.schedule != null) {
                MulticastRegistry.this.schedule.schedule(this, 10000L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

