/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.service;

import java.io.IOException;
import java.lang.reflect.Method;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.base.ClassUtils;
import vip.justlive.oxygen.core.util.base.MoreObjects;
import vip.justlive.supine.codec.KryoSerializer;
import vip.justlive.supine.codec.Serializer;
import vip.justlive.supine.common.RequestKey;
import vip.justlive.supine.common.ServiceConfig;
import vip.justlive.supine.registry.MulticastRegistry;
import vip.justlive.supine.registry.Registry;
import vip.justlive.supine.service.Service;
import vip.justlive.supine.service.ServiceMethodInvoker;
import vip.justlive.supine.transport.ServerTransport;
import vip.justlive.supine.transport.impl.AioServerTransport;

public class ServiceFactory {
    private final ServiceConfig config;
    private final Registry registry;
    private ServerTransport transport;
    private volatile boolean state;

    public ServiceFactory(ServiceConfig config) {
        this(config, ServiceFactory.select(config));
    }

    public ServiceFactory(ServiceConfig config, Registry registry) {
        this.config = config;
        this.registry = registry;
    }

    private static Registry select(ServiceConfig config) {
        if (config.getRegistryType() == 1) {
            return new MulticastRegistry(config);
        }
        return null;
    }

    public void register(Object service) {
        Service annotation = (Service)ClassUtils.getAnnotation((Class)ClassUtils.getActualClass(service.getClass()), Service.class);
        if (annotation != null) {
            this.register(service, annotation.version());
        } else {
            this.register(service, "");
        }
    }

    public void register(Object service, String version) {
        Class<?> serviceType = service.getClass();
        Class<?>[] interfaces = serviceType.getInterfaces();
        if (interfaces.length == 0) {
            return;
        }
        for (Class<?> intf : interfaces) {
            if (intf.getClassLoader() != null && intf.getName().startsWith("java.")) continue;
            this.register(intf, service, version);
        }
    }

    public void register(Class<?> interfaceType, Object service) {
        this.register(interfaceType, service, "");
    }

    public void register(Class<?> interfaceType, Object service, String version) {
        Method[] methods = interfaceType.getDeclaredMethods();
        if (methods.length == 0) {
            return;
        }
        Class<?> clazz = service.getClass();
        try {
            for (Method method : methods) {
                Method realMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                ServiceMethodInvoker.add(new RequestKey(version, interfaceType.getName(), method.getName(), method.getParameterTypes()).mark(), service, realMethod);
            }
        }
        catch (NoSuchMethodException e) {
            throw Exceptions.wrap((Throwable)e);
        }
    }

    public void start() throws IOException {
        if (this.state) {
            return;
        }
        this.state = true;
        this.transport = new AioServerTransport((Serializer)MoreObjects.firstNonNull((Object)this.config.getSerializer(), (Object)KryoSerializer.INSTANCE, (Object[])new Serializer[0]));
        this.transport.start(this.config.getHost(), this.config.getPort());
        if (this.registry != null) {
            this.registry.register(ServiceMethodInvoker.requestKeys());
            this.registry.start();
        }
    }

    public void stop() {
        if (!this.state) {
            return;
        }
        this.state = false;
        if (this.registry != null) {
            this.registry.stop();
        }
        this.transport.stop();
        ServiceMethodInvoker.clear();
    }
}

