/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.transport.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import vip.justlive.oxygen.core.util.net.aio.ChannelContext;
import vip.justlive.oxygen.core.util.net.aio.Client;
import vip.justlive.oxygen.core.util.net.aio.LengthFrame;
import vip.justlive.supine.codec.Serializer;
import vip.justlive.supine.common.Request;
import vip.justlive.supine.common.RequestKey;
import vip.justlive.supine.common.RequestKeyWrapper;
import vip.justlive.supine.transport.ClientTransport;
import vip.justlive.supine.transport.impl.Transport;

public class AioClientTransport
implements ClientTransport {
    private final Client client;
    private final Serializer serializer;
    private ChannelContext channel;

    @Override
    public void connect(InetSocketAddress address) throws IOException {
        this.channel = this.client.connect(address);
        Transport transport = new Transport(this.channel);
        this.channel.addAttr(Transport.class.getName(), (Object)transport);
        try {
            transport.join(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.channel == null || this.channel.isClosed();
    }

    @Override
    public void send(Request request) {
        this.channel.write((Object)new LengthFrame().setType(1).setBody(this.serializer.encode(request)));
    }

    @Override
    public Integer lookup(RequestKey key) {
        if (this.isClosed()) {
            return null;
        }
        RequestKeyWrapper wrapper = (RequestKeyWrapper)this.channel.getAttr(RequestKey.class.getName());
        if (wrapper != null) {
            return wrapper.lookup(key);
        }
        return null;
    }

    public AioClientTransport(Client client, Serializer serializer) {
        this.client = client;
        this.serializer = serializer;
    }
}

