/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.supine.transport.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.exception.WrappedException;
import vip.justlive.oxygen.core.util.net.aio.AioListener;
import vip.justlive.oxygen.core.util.net.aio.ChannelContext;
import vip.justlive.oxygen.core.util.net.aio.LengthFrame;
import vip.justlive.oxygen.core.util.net.aio.LengthFrameHandler;
import vip.justlive.supine.codec.Serializer;
import vip.justlive.supine.common.Request;
import vip.justlive.supine.common.RequestKeyWrapper;
import vip.justlive.supine.common.Response;
import vip.justlive.supine.service.ServiceMethodInvoker;

public class ServerHandler
extends LengthFrameHandler
implements AioListener {
    private static final Logger log = LoggerFactory.getLogger(ServerHandler.class);
    private final Serializer serializer;

    public void onConnected(ChannelContext channelContext) {
        channelContext.write((Object)new LengthFrame().setType(3).setBody(this.serializer.encode(new RequestKeyWrapper(ServiceMethodInvoker.requestKeys()))));
    }

    public void handle(Object data, ChannelContext channelContext) {
        LengthFrame frame = (LengthFrame)data;
        if (frame.getType() == -1) {
            return;
        }
        Request request = (Request)this.serializer.decode(frame.getBody());
        ServiceMethodInvoker invoker = ServiceMethodInvoker.lookup(request.getMid());
        Response response = new Response().setId(request.getId());
        if (invoker == null) {
            log.warn("not found service for {} in {}", (Object)request, ServiceMethodInvoker.requestKeys());
            response.setException((Throwable)Exceptions.fail((String)"\u8fdc\u7a0b\u670d\u52a1\u6ca1\u6709\u5bf9\u5e94\u7248\u672c\u7684\u5b9e\u73b0"));
        } else {
            try {
                response.setResult(invoker.invoke(request.getArgs()));
            }
            catch (WrappedException e) {
                response.setException(e.getException());
            }
            catch (Throwable e) {
                response.setException(e);
            }
        }
        channelContext.write((Object)new LengthFrame().setType(2).setBody(this.serializer.encode(response)));
    }

    public ServerHandler(Serializer serializer) {
        this.serializer = serializer;
    }
}

