/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.mail.core;

import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.ObjectUtils;
import vip.mate.core.mail.core.MailTemplate;

public class JavaMailTemplate
implements MailTemplate {
    private static final Logger log = LoggerFactory.getLogger(JavaMailTemplate.class);
    private final JavaMailSender mailSender;
    private final MailProperties mailProperties;

    @Override
    public void sendSimpleMail(String to, String subject, String content, String ... cc) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.mailProperties.getUsername());
        message.setTo(to);
        message.setSubject(subject);
        message.setText(content);
        if (!ObjectUtils.isEmpty((Object[])cc)) {
            message.setCc(cc);
        }
        this.mailSender.send(message);
    }

    @Override
    public void sendHtmlMail(String to, String subject, String content, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = this.buildHelper(to, subject, content, message, cc);
        this.mailSender.send(message);
    }

    @Override
    public void sendAttachmentsMail(String to, String subject, String content, String filePath, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = this.buildHelper(to, subject, content, message, cc);
        FileSystemResource file = new FileSystemResource(new File(filePath));
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator));
        helper.addAttachment(fileName, (InputStreamSource)file);
        this.mailSender.send(message);
    }

    @Override
    public void sendResourceMail(String to, String subject, String content, String rscPath, String rscId, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = this.buildHelper(to, subject, content, message, cc);
        FileSystemResource res = new FileSystemResource(new File(rscPath));
        helper.addInline(rscId, (Resource)res);
        this.mailSender.send(message);
    }

    private MimeMessageHelper buildHelper(String to, String subject, String content, MimeMessage message, String ... cc) throws MessagingException {
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(this.mailProperties.getUsername());
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(content, true);
        if (!ObjectUtils.isEmpty((Object[])cc)) {
            helper.setCc(cc);
        }
        return helper;
    }

    public JavaMailTemplate(JavaMailSender mailSender, MailProperties mailProperties) {
        this.mailSender = mailSender;
        this.mailProperties = mailProperties;
    }
}

