/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskServiceFactory;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.Protocol;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigServletInner {
    private static final int TRY_GET_LOCK_TIMES = 9;
    private static final int START_LONG_POLLING_VERSION_NUM = 204;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServletInner.class);
    private final LongPollingService longPollingService;

    public ConfigServletInner(LongPollingService longPollingService) {
        this.longPollingService = longPollingService;
    }

    public String doPollingConfig(HttpServletRequest request, HttpServletResponse response, Map<String, String> clientMd5Map, int probeRequestSize) throws IOException {
        int versionNum;
        if (LongPollingService.isSupportLongPolling(request)) {
            this.longPollingService.addLongPollingClient(request, response, clientMd5Map, probeRequestSize);
            return "200";
        }
        List<String> changedGroups = MD5Util.compareMd5(request, response, clientMd5Map);
        String oldResult = MD5Util.compareMd5OldResult(changedGroups);
        String newResult = MD5Util.compareMd5ResultString(changedGroups);
        String version = request.getHeader("Client-Version");
        if (version == null) {
            version = "2.0.0";
        }
        if ((versionNum = Protocol.getVersionNumber(version)) < 204) {
            response.addHeader("Probe-Modify-Response", oldResult);
            response.addHeader("Probe-Modify-Response-New", newResult);
        } else {
            request.setAttribute("content", (Object)newResult);
        }
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache,no-store");
        response.setStatus(200);
        return "200";
    }

    public String doGetConfig(HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String tag, String isNotify, String clientIp) throws IOException, ServletException {
        return this.doGetConfig(request, response, dataId, group, tenant, tag, isNotify, clientIp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetConfig(HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String tag, String isNotify, String clientIp, boolean isV2) throws IOException {
        boolean notify = StringUtils.isNotBlank((String)isNotify) && Boolean.parseBoolean(isNotify);
        String acceptCharset = "UTF-8";
        if (isV2) {
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
        }
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String autoTag = request.getHeader("Vipserver-Tag");
        String requestIpApp = RequestUtil.getAppName(request);
        int lockResult = ConfigCacheService.tryConfigReadLock(groupKey);
        CacheItem cacheItem = ConfigCacheService.getContentCache(groupKey);
        String requestIp = RequestUtil.getRemoteIp(request);
        if (lockResult > 0 && cacheItem != null) {
            try {
                Object configCacheTag;
                String content;
                String encryptedDataKey;
                long lastModified;
                String md5;
                String pullEvent;
                boolean isBeta = cacheItem.isBeta() && cacheItem.getConfigCacheBeta() != null && cacheItem.getIps4Beta() != null && cacheItem.getIps4Beta().contains(clientIp);
                String configType = null != cacheItem.getType() ? cacheItem.getType() : FileTypeEnum.TEXT.getFileType();
                response.setHeader("Config-Type", configType);
                FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(configType);
                String contentTypeHeader = fileTypeEnum.getContentType();
                response.setHeader("Content-Type", isV2 ? "application/json;charset=UTF-8" : contentTypeHeader);
                if (isBeta) {
                    ConfigCache configCacheBeta = cacheItem.getConfigCacheBeta();
                    pullEvent = "pull-beta";
                    md5 = configCacheBeta.getMd5(acceptCharset);
                    lastModified = configCacheBeta.getLastModifiedTs();
                    encryptedDataKey = configCacheBeta.getEncryptedDataKey();
                    content = ConfigDiskServiceFactory.getInstance().getBetaContent(dataId, group, tenant);
                    response.setHeader("isBeta", "true");
                } else if (StringUtils.isBlank((CharSequence)tag)) {
                    if (ConfigServletInner.isUseTag(cacheItem, autoTag)) {
                        configCacheTag = cacheItem.getConfigCacheTags().get(autoTag);
                        md5 = ((ConfigCache)configCacheTag).getMd5(acceptCharset);
                        lastModified = ((ConfigCache)configCacheTag).getLastModifiedTs();
                        encryptedDataKey = ((ConfigCache)configCacheTag).getEncryptedDataKey();
                        content = ConfigDiskServiceFactory.getInstance().getTagContent(dataId, group, tenant, autoTag);
                        pullEvent = "pull-tag-" + autoTag;
                        response.setHeader("Vipserver-Tag", URLEncoder.encode(autoTag, StandardCharsets.UTF_8.displayName()));
                    } else {
                        pullEvent = "pull";
                        md5 = cacheItem.getConfigCache().getMd5(acceptCharset);
                        lastModified = cacheItem.getConfigCache().getLastModifiedTs();
                        encryptedDataKey = cacheItem.getConfigCache().getEncryptedDataKey();
                        content = ConfigDiskServiceFactory.getInstance().getContent(dataId, group, tenant);
                    }
                } else {
                    md5 = cacheItem.getTagMd5(tag, acceptCharset);
                    lastModified = cacheItem.getTagLastModified(tag);
                    encryptedDataKey = cacheItem.getTagEncryptedDataKey(tag);
                    content = ConfigDiskServiceFactory.getInstance().getTagContent(dataId, group, tenant, tag);
                    pullEvent = "pull-tag-" + tag;
                }
                if (content == null) {
                    ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, pullEvent, "not-found", -1L, requestIp, notify, "http");
                    configCacheTag = this.get404Result(response, isV2);
                    return configCacheTag;
                }
                response.setHeader("Content-MD5", md5);
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
                response.setHeader("Cache-Control", "no-cache,no-store");
                response.setDateHeader("Last-Modified", lastModified);
                if (encryptedDataKey != null) {
                    response.setHeader("Encrypted-Data-Key", encryptedDataKey);
                }
                Pair pair = EncryptionHandler.decryptHandler((String)dataId, (String)encryptedDataKey, (String)content);
                String decryptContent = (String)pair.getSecond();
                PrintWriter out = response.getWriter();
                if (isV2) {
                    out.print(JacksonUtils.toJson((Object)Result.success((Object)decryptContent)));
                } else {
                    out.print(decryptContent);
                }
                out.flush();
                out.close();
                LogUtil.PULL_CHECK_LOG.warn("{}|{}|{}|{}", new Object[]{groupKey, requestIp, md5, TimeUtils.getCurrentTimeStr()});
                long delayed = notify ? -1L : System.currentTimeMillis() - lastModified;
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, lastModified, pullEvent, "ok", delayed, clientIp, notify, "http");
            }
            finally {
                ConfigCacheService.releaseReadLock(groupKey);
            }
        } else {
            if (lockResult == 0 || cacheItem == null) {
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "pull", "not-found", -1L, requestIp, notify, "http");
                return this.get404Result(response, isV2);
            }
            LogUtil.PULL_LOG.info("[client-get] clientIp={}, {}, get data during dump", (Object)clientIp, (Object)groupKey);
            return this.get409Result(response, isV2);
        }
        return "200";
    }

    private String get404Result(HttpServletResponse response, boolean isV2) throws IOException {
        response.setStatus(404);
        PrintWriter writer = response.getWriter();
        if (isV2) {
            writer.println(JacksonUtils.toJson((Object)Result.failure((ErrorCode)ErrorCode.RESOURCE_NOT_FOUND, (Object)"config data not exist")));
        } else {
            writer.println("config data not exist");
        }
        return "404";
    }

    private String get409Result(HttpServletResponse response, boolean isV2) throws IOException {
        response.setStatus(409);
        PrintWriter writer = response.getWriter();
        if (isV2) {
            writer.println(JacksonUtils.toJson((Object)Result.failure((ErrorCode)ErrorCode.RESOURCE_CONFLICT, (Object)"requested file is being modified, please try later.")));
        } else {
            writer.println("requested file is being modified, please try later.");
        }
        return "409";
    }

    private static boolean isUseTag(CacheItem cacheItem, String tag) {
        return cacheItem != null && cacheItem.getConfigCacheTags() != null && cacheItem.getConfigCacheTags().containsKey(tag);
    }
}

