/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigDetailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigDetailService.class);
    private final ConfigInfoPersistService configInfoPersistService;
    private BlockingQueue<SearchEvent> eventLinkedBlockingQueue;
    private ScheduledExecutorService clientEventExecutor;
    private static int maxCapacity = 4;
    private static final int MAX_CAPACITY = 32;
    private static long waitTimeout = 8000L;
    private static int maxThread = 2;
    private static final int MAX_THREAD = 16;

    public ConfigDetailService(ConfigInfoPersistService configInfoPersistService) {
        this.configInfoPersistService = configInfoPersistService;
        this.loadSetting();
        this.initWorker();
    }

    private void loadSetting() {
        ConfigDetailService.setMaxCapacity(Math.min(Integer.parseInt(EnvUtil.getProperty((String)"nacos.config.search.max_capacity", (String)String.valueOf(ConfigDetailService.getMaxCapacity()))), 32));
        ConfigDetailService.setMaxThread(Math.min(Integer.parseInt(EnvUtil.getProperty((String)"nacos.config.search.max_thread", (String)String.valueOf(ConfigDetailService.getMaxThread()))), 16));
        ConfigDetailService.setWaitTimeout(Integer.parseInt(EnvUtil.getProperty((String)"nacos.config.search.wait_timeout", (String)String.valueOf(ConfigDetailService.getWaitTimeout()))));
    }

    private void initWorker() {
        this.eventLinkedBlockingQueue = new LinkedBlockingQueue<SearchEvent>(maxCapacity);
        this.clientEventExecutor = new ScheduledThreadPoolExecutor(maxThread, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.config.search.worker"));
        for (int i = 0; i < maxThread; ++i) {
            this.clientEventExecutor.submit(() -> {
                while (true) {
                    try {
                        while (true) {
                            SearchEvent event = this.eventLinkedBlockingQueue.take();
                            Page<ConfigInfo> result = null;
                            result = "blur".equals(event.getType()) ? this.configInfoPersistService.findConfigInfoLike4Page(event.pageNo, event.pageSize, event.dataId, event.group, event.tenant, event.configAdvanceInfo) : this.configInfoPersistService.findConfigInfo4Page(event.pageNo, event.pageSize, event.dataId, event.group, event.tenant, event.configAdvanceInfo);
                            SearchEvent searchEvent = event;
                            synchronized (searchEvent) {
                                event.setResponse(result);
                                event.notifyAll();
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("catch search worker error: {}", (Object)e.getMessage());
                        continue;
                    }
                    break;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<ConfigInfo> findConfigInfoPage(String search, int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) throws NacosRuntimeException {
        SearchEvent searchEvent = new SearchEvent(search, pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        Page<ConfigInfo> result = null;
        try {
            SearchEvent searchEvent2 = searchEvent;
            synchronized (searchEvent2) {
                boolean offer = this.eventLinkedBlockingQueue.offer(searchEvent);
                if (!offer) {
                    throw new NacosRuntimeException(503, "server limit match.");
                }
                searchEvent.wait(waitTimeout);
                result = searchEvent.getResponse();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("get config detail timeout: {}.", (Object)e.getMessage());
            throw new NacosRuntimeException(503, "server limit match.");
        }
        if (result == null) {
            throw new NacosRuntimeException(503, "server limit match.");
        }
        return result;
    }

    public static int getMaxCapacity() {
        return maxCapacity;
    }

    public static void setMaxCapacity(int maxCapacity) {
        ConfigDetailService.maxCapacity = maxCapacity;
    }

    public static long getWaitTimeout() {
        return waitTimeout;
    }

    public static void setWaitTimeout(long waitTimeout) {
        ConfigDetailService.waitTimeout = waitTimeout;
    }

    public static int getMaxThread() {
        return maxThread;
    }

    public static void setMaxThread(int maxThread) {
        ConfigDetailService.maxThread = maxThread;
    }

    public static class SearchEvent {
        private String type;
        private int pageNo;
        private int pageSize;
        private String dataId;
        private String group;
        private String tenant;
        private Map<String, Object> configAdvanceInfo;
        private Page<ConfigInfo> response;

        public SearchEvent() {
        }

        public SearchEvent(String type, int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
            this.type = type;
            this.pageNo = pageNo;
            this.pageSize = pageSize;
            this.dataId = dataId;
            this.group = group;
            this.tenant = tenant;
            this.configAdvanceInfo = configAdvanceInfo;
        }

        public String getType() {
            return this.type;
        }

        public int getPageNo() {
            return this.pageNo;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public String getDataId() {
            return this.dataId;
        }

        public String getGroup() {
            return this.group;
        }

        public String getTenant() {
            return this.tenant;
        }

        public Map<String, Object> getConfigAdvanceInfo() {
            return this.configAdvanceInfo;
        }

        public Page<ConfigInfo> getResponse() {
            return this.response;
        }

        public void setResponse(Page<ConfigInfo> response) {
            this.response = response;
        }
    }
}

