/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.capacity;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.capacity.TenantCapacity;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.TenantCapacityMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class TenantCapacityPersistService {
    private static final TenantCapacityRowMapper TENANT_CAPACITY_ROW_MAPPER = new TenantCapacityRowMapper();
    private JdbcTemplate jdbcTemplate;
    private DataSourceService dataSourceService;
    private MapperManager mapperManager;

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.jdbcTemplate = this.dataSourceService.getJdbcTemplate();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    public TenantCapacity getTenantCapacity(String tenantId) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        String sql = tenantCapacityMapper.select(Arrays.asList("id", "quota", "`usage`", "`max_size`", "max_aggr_count", "max_aggr_size", "tenant_id"), Collections.singletonList("tenant_id"));
        List list = this.jdbcTemplate.query(sql, new Object[]{tenantId}, (RowMapper)TENANT_CAPACITY_ROW_MAPPER);
        if (list.isEmpty()) {
            return null;
        }
        return (TenantCapacity)list.get(0);
    }

    public boolean insertTenantCapacity(TenantCapacity tenantCapacity) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("tenantId", (Object)tenantCapacity.getTenant());
        context.putUpdateParameter("quota", (Object)tenantCapacity.getQuota());
        context.putUpdateParameter("maxSize", (Object)tenantCapacity.getMaxSize());
        context.putUpdateParameter("maxAggrSize", (Object)tenantCapacity.getMaxAggrSize());
        context.putUpdateParameter("maxAggrCount", (Object)tenantCapacity.getMaxAggrCount());
        context.putUpdateParameter("gmtCreate", (Object)tenantCapacity.getGmtCreate());
        context.putUpdateParameter("gmtModified", (Object)tenantCapacity.getGmtModified());
        context.putWhereParameter("tenantId", (Object)tenantCapacity.getTenant());
        MapperResult mapperResult = tenantCapacityMapper.insertTenantCapacity(context);
        try {
            return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) > 0;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithDefaultQuotaLimit(TenantCapacity tenantCapacity) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)tenantCapacity.getGmtModified());
        context.putWhereParameter("tenantId", (Object)tenantCapacity.getTenant());
        context.putWhereParameter("usage", (Object)tenantCapacity.getQuota());
        MapperResult mapperResult = tenantCapacityMapper.incrementUsageWithDefaultQuotaLimit(context);
        try {
            int affectRow = this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray());
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsageWithQuotaLimit(TenantCapacity tenantCapacity) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)tenantCapacity.getGmtModified());
        context.putWhereParameter("tenantId", (Object)tenantCapacity.getTenant());
        MapperResult mapperResult = tenantCapacityMapper.incrementUsageWithQuotaLimit(context);
        try {
            return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean incrementUsage(TenantCapacity tenantCapacity) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)tenantCapacity.getGmtModified());
        context.putWhereParameter("tenantId", (Object)tenantCapacity.getTenant());
        MapperResult mapperResult = tenantCapacityMapper.incrementUsage(context);
        try {
            int affectRow = this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray());
            return affectRow == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean decrementUsage(TenantCapacity tenantCapacity) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)tenantCapacity.getGmtModified());
        context.putWhereParameter("tenantId", (Object)tenantCapacity.getTenant());
        MapperResult mapperResult = tenantCapacityMapper.decrementUsage(context);
        try {
            return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateTenantCapacity(String tenant, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        List argList = CollectionUtils.list((Object[])new Object[0]);
        ArrayList<String> columns = new ArrayList<String>();
        if (quota != null) {
            columns.add("quota");
            argList.add(quota);
        }
        if (maxSize != null) {
            columns.add("max_size");
            argList.add(maxSize);
        }
        if (maxAggrCount != null) {
            columns.add("max_aggr_count");
            argList.add(maxAggrCount);
        }
        if (maxAggrSize != null) {
            columns.add("max_aggr_size");
            argList.add(maxAggrSize);
        }
        columns.add("gmt_modified");
        argList.add(TimeUtils.getCurrentTime());
        ArrayList<String> where = new ArrayList<String>();
        where.add("tenant_id");
        argList.add(tenant);
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        String sql = tenantCapacityMapper.update(columns, where);
        try {
            return this.jdbcTemplate.update(sql, argList.toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean updateQuota(String tenant, Integer quota) {
        return this.updateTenantCapacity(tenant, quota, null, null, null);
    }

    public boolean correctUsage(String tenant, Timestamp gmtModified) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        MapperContext context = new MapperContext();
        context.putUpdateParameter("gmtModified", (Object)gmtModified);
        context.putWhereParameter("tenantId", (Object)tenant);
        MapperResult mapperResult = tenantCapacityMapper.correctUsage(context);
        try {
            return this.jdbcTemplate.update(mapperResult.getSql(), mapperResult.getParamList().toArray()) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public List<TenantCapacity> getCapacityList4CorrectUsage(long lastId, int pageSize) {
        TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
        MapperContext context = new MapperContext();
        context.putWhereParameter("id", (Object)lastId);
        context.putWhereParameter("limitSize", (Object)pageSize);
        MapperResult mapperResult = tenantCapacityMapper.getCapacityList4CorrectUsage(context);
        try {
            return this.jdbcTemplate.query(mapperResult.getSql(), mapperResult.getParamList().toArray(), (rs, rowNum) -> {
                TenantCapacity tenantCapacity = new TenantCapacity();
                tenantCapacity.setId(rs.getLong("id"));
                tenantCapacity.setTenant(rs.getString("tenant_id"));
                return tenantCapacity;
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    public boolean deleteTenantCapacity(String tenant) {
        try {
            TenantCapacityMapper tenantCapacityMapper = (TenantCapacityMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "tenant_capacity");
            PreparedStatementCreator preparedStatementCreator = connection -> {
                PreparedStatement ps = connection.prepareStatement(tenantCapacityMapper.delete(Collections.singletonList("tenant_id")));
                ps.setString(1, tenant);
                return ps;
            };
            return this.jdbcTemplate.update(preparedStatementCreator) == 1;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error]", (Throwable)e);
            throw e;
        }
    }

    static final class TenantCapacityRowMapper
    implements RowMapper<TenantCapacity> {
        TenantCapacityRowMapper() {
        }

        public TenantCapacity mapRow(ResultSet rs, int rowNum) throws SQLException {
            TenantCapacity tenantCapacity = new TenantCapacity();
            tenantCapacity.setId(rs.getLong("id"));
            tenantCapacity.setQuota(rs.getInt("quota"));
            tenantCapacity.setUsage(rs.getInt("usage"));
            tenantCapacity.setMaxSize(rs.getInt("max_size"));
            tenantCapacity.setMaxAggrCount(rs.getInt("max_aggr_count"));
            tenantCapacity.setMaxAggrSize(rs.getInt("max_aggr_size"));
            tenantCapacity.setTenant(rs.getString("tenant_id"));
            return tenantCapacity;
        }
    }
}

