/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.processor;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.persistence.model.Page;

public class DumpAllTagProcessor
implements NacosTaskProcessor {
    static final int PAGE_SIZE = 1000;
    final ConfigInfoTagPersistService configInfoTagPersistService;

    public DumpAllTagProcessor(ConfigInfoTagPersistService configInfoTagPersistService) {
        this.configInfoTagPersistService = configInfoTagPersistService;
    }

    public boolean process(NacosTask task) {
        int rowCount = this.configInfoTagPersistService.configInfoTagCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 1000.0);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<ConfigInfoTagWrapper> page = this.configInfoTagPersistService.findAllConfigInfoTagForDumpAll(pageNo, 1000);
            if (page == null) continue;
            for (ConfigInfoTagWrapper cf : page.getPageItems()) {
                boolean result = ConfigCacheService.dumpTag(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getTag(), cf.getContent(), cf.getLastModified(), cf.getEncryptedDataKey());
                LogUtil.DUMP_LOG.info("[dump-all-Tag-ok] result={}, {}, {}, length={}, md5={}", new Object[]{result, GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), cf.getContent().length(), cf.getMd5()});
            }
            LogUtil.DEFAULT_LOG.info("[all-dump-tag] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }
}

