/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro.v2;

import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.cluster.remote.ClusterRpcClientProxy;
import com.alibaba.nacos.core.distributed.distro.DistroProtocol;
import com.alibaba.nacos.core.distributed.distro.component.DistroComponentHolder;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataProcessor;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataStorage;
import com.alibaba.nacos.core.distributed.distro.component.DistroFailedTaskHandler;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import com.alibaba.nacos.core.distributed.distro.task.DistroTaskEngineHolder;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.v2.DistroClientDataProcessor;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.v2.DistroClientTaskFailedHandler;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.v2.DistroClientTransportAgent;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManagerDelegate;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class DistroClientComponentRegistry {
    private final ServerMemberManager serverMemberManager;
    private final DistroProtocol distroProtocol;
    private final DistroComponentHolder componentHolder;
    private final DistroTaskEngineHolder taskEngineHolder;
    private final ClientManager clientManager;
    private final ClusterRpcClientProxy clusterRpcClientProxy;

    public DistroClientComponentRegistry(ServerMemberManager serverMemberManager, DistroProtocol distroProtocol, DistroComponentHolder componentHolder, DistroTaskEngineHolder taskEngineHolder, ClientManagerDelegate clientManager, ClusterRpcClientProxy clusterRpcClientProxy) {
        this.serverMemberManager = serverMemberManager;
        this.distroProtocol = distroProtocol;
        this.componentHolder = componentHolder;
        this.taskEngineHolder = taskEngineHolder;
        this.clientManager = clientManager;
        this.clusterRpcClientProxy = clusterRpcClientProxy;
    }

    @PostConstruct
    public void doRegister() {
        DistroClientDataProcessor dataProcessor = new DistroClientDataProcessor(this.clientManager, this.distroProtocol);
        DistroClientTransportAgent transportAgent = new DistroClientTransportAgent(this.clusterRpcClientProxy, this.serverMemberManager);
        DistroClientTaskFailedHandler taskFailedHandler = new DistroClientTaskFailedHandler(this.taskEngineHolder);
        this.componentHolder.registerDataStorage("Nacos:Naming:v2:ClientData", (DistroDataStorage)dataProcessor);
        this.componentHolder.registerDataProcessor((DistroDataProcessor)dataProcessor);
        this.componentHolder.registerTransportAgent("Nacos:Naming:v2:ClientData", (DistroTransportAgent)transportAgent);
        this.componentHolder.registerFailedTaskHandler("Nacos:Naming:v2:ClientData", (DistroFailedTaskHandler)taskFailedHandler);
    }
}

