/*
 * Decompiled with CFR 0.152.
 */
package vn._7team.common.model;

import java.util.ArrayList;
import java.util.List;
import vn._7team.common.util.JsonUtil;

public class Page<E> {
    private int pageNumber;
    private int pageSize;
    public List<E> pageItems;
    private long totalItems;
    private int pagesAvailable;
    private long time;

    public Page() {
        this.pageItems = new ArrayList(10);
    }

    public Page(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.pageItems = new ArrayList(pageSize);
    }

    public Page(int pageNumber, int pageSize, long totalItems) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.pageItems = new ArrayList(pageSize);
        this.totalItems = totalItems;
        this.computePagesAvailable(totalItems, pageSize);
    }

    public Page(int pageNumber, int pageSize, long totalItems, int pagesAvailable) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.pageItems = new ArrayList(pageSize);
        this.totalItems = totalItems;
        this.pagesAvailable = pagesAvailable;
    }

    public Page(int pageNumber, int pageSize, List<E> pageItems, long totalItems) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.pageItems = pageItems;
        this.totalItems = totalItems;
        this.computePagesAvailable(totalItems, pageSize);
    }

    public Page(int pageNumber, int pageSize, List<E> pageItems, long totalItems, int pagesAvailable) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.pageItems = pageItems;
        this.totalItems = totalItems;
        this.pagesAvailable = pagesAvailable;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPagesAvailable() {
        return this.pagesAvailable;
    }

    public void setPagesAvailable(int pagesAvailable) {
        this.pagesAvailable = pagesAvailable;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(long totalItems) {
        this.totalItems = totalItems;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public List<E> getPageItems() {
        return this.pageItems;
    }

    public void setPageItems(List<E> pageItems) {
        this.pageItems = pageItems;
    }

    public void computePagesAvailable(long totalItems, int pageSize) {
        this.pagesAvailable = 0;
        this.pagesAvailable = totalItems % (long)pageSize == 0L ? (int)(totalItems / (long)pageSize) : (int)(totalItems / (long)pageSize) + 1;
    }

    public String toString() {
        return JsonUtil.toJson(this);
    }
}

