/*
 * Decompiled with CFR 0.152.
 */
package vn._7team.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import vn._7team.common.util.DateUtil;
import vn._7team.common.util.StringUtil;

public class CalendarUtil {
    public static void toBeginDate(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static void toEndDate(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
    }

    public static Date toBeginDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        CalendarUtil.toBeginDate(cal);
        return cal.getTime();
    }

    public static Date toEndDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        CalendarUtil.toEndDate(cal);
        return cal.getTime();
    }

    public static Calendar toCalendar(String dateString, String format) {
        try {
            if (StringUtil.isEmpty(dateString) || StringUtil.isEmpty(format)) {
                return null;
            }
            SimpleDateFormat df = new SimpleDateFormat(format);
            Date date = df.parse(dateString);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        return sdf.format(Calendar.getInstance().getTime());
    }

    public static long getCurrentTimeInMillis() {
        Calendar cal = Calendar.getInstance();
        return cal.getTimeInMillis();
    }

    public static long getBeginOfCurrentTimeInMillis() {
        Calendar cal = Calendar.getInstance();
        CalendarUtil.toBeginDate(cal);
        return cal.getTimeInMillis();
    }

    public static Date getDateNearCurrentMost(List<Date> dates) {
        final long now = Calendar.getInstance().getTimeInMillis();
        Date closest = Collections.min(dates, new Comparator<Date>(){

            @Override
            public int compare(Date d1, Date d2) {
                long diff1 = Math.abs(d1.getTime() - now);
                long diff2 = Math.abs(d2.getTime() - now);
                return Long.compare(diff1, diff2);
            }
        });
        return closest;
    }

    public static long getDateInMillisecondsNearCurrentMost(List<Long> dates) {
        final long now = Calendar.getInstance().getTimeInMillis();
        Long closest = Collections.min(dates, new Comparator<Long>(){

            @Override
            public int compare(Long d1, Long d2) {
                long diff1 = Math.abs(d1 - now);
                long diff2 = Math.abs(d2 - now);
                return Long.compare(diff1, diff2);
            }
        });
        return closest;
    }

    public static int getDayOfWeek(long timeInMiliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeInMiliseconds);
        return cal.get(7);
    }

    public static String getLastDayOfMonth(String format) {
        Date today = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        Long lastDayOfMonth = cal.getTimeInMillis();
        return DateUtil.toDateString(lastDayOfMonth, format);
    }
}

