/*
 * Decompiled with CFR 0.152.
 */
package vn._7team.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <O> String toJson(O o) {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static <T> T toObject(String jsonStr, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T toObject(String jsonStr, TypeReference<T> reference) {
        try {
            return (T)MAPPER.readValue(jsonStr, reference);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

