/*
 * Decompiled with CFR 0.152.
 */
package vn._7team.common.validator;

import java.util.Date;
import java.util.regex.Matcher;
import vn._7team.common.CommonConstant;
import vn._7team.common.exception.SevenTeamException;
import vn._7team.common.util.DateUtil;
import vn._7team.common.util.StringUtil;
import vn._7team.common.validator.PhoneValidator;

public abstract class InputValidator {
    public void validateEmptyField(String value) throws SevenTeamException {
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException();
        }
    }

    public void validateEmptyField(String value, String message) throws SevenTeamException {
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException(message);
        }
    }

    public void validateEmptyField(Integer value) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
    }

    public void validateEmptyField(Integer value, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
    }

    public void validateEmptyField(Long value) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
    }

    public void validateEmptyField(Long value, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
    }

    public void validateEmptyField(Short value) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
    }

    public void validateEmptyField(Short value, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
    }

    public void validateEmptyField(Double value) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
    }

    public void validateEmptyField(Double value, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
    }

    public void validateEmptyField(Float value) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
    }

    public void validateEmptyField(Float value, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
    }

    public void validateIntegerField(String value) throws SevenTeamException {
        char[] chars;
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException();
        }
        for (char c : chars = value.toCharArray()) {
            if (Character.isDigit(c) || c == '_' || c == ',') continue;
            throw new SevenTeamException.InvalidFormatDataException();
        }
    }

    public void validateIntegerField(String value, String message) throws SevenTeamException {
        char[] chars;
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException(message);
        }
        for (char c : chars = value.toCharArray()) {
            if (Character.isDigit(c) || c == '_' || c == ',') continue;
            throw new SevenTeamException.InvalidFormatDataException(message);
        }
    }

    public void validateFloatField(String value) throws SevenTeamException {
        char[] chars;
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException();
        }
        for (char c : chars = value.toCharArray()) {
            if (Character.isDigit(c) || c == '_' || c == ',' || c == '.') continue;
            throw new SevenTeamException.InvalidFormatDataException();
        }
    }

    public void validateFloatField(String value, String message) throws SevenTeamException {
        char[] chars;
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException(message);
        }
        for (char c : chars = value.toCharArray()) {
            if (Character.isDigit(c) || c == '_' || c == ',' || c == '.') continue;
            throw new SevenTeamException.InvalidFormatDataException(message);
        }
    }

    public Date validateDateTimeField(String value, String format) throws SevenTeamException {
        if (StringUtil.isEmpty(value) || StringUtil.isEmpty(format)) {
            throw new SevenTeamException.NoDataException();
        }
        Date date = DateUtil.toDate(value, format);
        if (date == null) {
            throw new SevenTeamException.InvalidFormatDataException();
        }
        return date;
    }

    public Date validateDateTimeField(String value, String format, String message) throws SevenTeamException {
        if (StringUtil.isEmpty(value) || StringUtil.isEmpty(format)) {
            throw new SevenTeamException.NoDataException(message);
        }
        Date date = DateUtil.toDate(value, format);
        if (date == null) {
            throw new SevenTeamException.InvalidFormatDataException(message);
        }
        return date;
    }

    public void validateEmailField(String value) throws SevenTeamException {
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException();
        }
        Matcher matcher = CommonConstant.EMAIL_PATTERN.matcher(value.trim());
        if (matcher.matches()) {
            return;
        }
        throw new SevenTeamException.InvalidFormatDataException();
    }

    public void validateEmailField(String value, String message) throws SevenTeamException {
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException(message);
        }
        Matcher matcher = CommonConstant.EMAIL_PATTERN.matcher(value.trim());
        if (matcher.matches()) {
            return;
        }
        throw new SevenTeamException.InvalidFormatDataException(message);
    }

    public String validatePhoneField(String value) throws SevenTeamException {
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException();
        }
        String phone = PhoneValidator.validPhoneNumber(value);
        if (phone == null) {
            throw new SevenTeamException.InvalidFormatDataException();
        }
        return phone;
    }

    public String validatePhoneField(String value, String message) throws SevenTeamException {
        if (StringUtil.isEmpty(value)) {
            throw new SevenTeamException.NoDataException(message);
        }
        String phone = PhoneValidator.validPhoneNumber(value);
        if (phone == null) {
            throw new SevenTeamException.InvalidFormatDataException(message);
        }
        return phone;
    }

    public void validateRangeField(Long value, long min, long max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        long data = value;
        if (data < min || data > max) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateRangeField(Long value, long min, long max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        long data = value;
        if (data < min || data > max) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateRangeField(Integer value, int min, int max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        int data = value;
        if (data < min || data > max) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateRangeField(Integer value, int min, int max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        int data = value;
        if (data < min || data > max) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateRangeField(Short value, short min, short max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        short data = value;
        if (data < min || data > max) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateRangeField(Short value, short min, short max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        short data = value;
        if (data < min || data > max) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateRangeField(Date value, Date min, Date max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        if (value.before(min) || value.after(max)) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateRangeField(Date value, Date min, Date max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        if (value.before(min) || value.after(max)) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateRangeLengthField(String value, int minLength, int maxLength) throws SevenTeamException {
        if (value.length() >= minLength && value.length() <= maxLength) {
            return;
        }
        throw new SevenTeamException.InvalidDataException("Invalid Range Length (" + minLength + ", " + maxLength + ")");
    }

    public void validateRangeLengthField(String value, int minLength, int maxLength, String message) throws SevenTeamException {
        if (value.length() >= minLength && value.length() <= maxLength) {
            return;
        }
        throw new SevenTeamException.InvalidDataException(message);
    }

    public void validateMinField(Long value, long min) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        long data = value;
        if (data < min) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMinField(Long value, long min, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        long data = value;
        if (data < min) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMinField(Integer value, int min) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        int data = value;
        if (data < min) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMinField(Integer value, int min, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        int data = value;
        if (data < min) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMinField(Short value, short min) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        short data = value;
        if (data < min) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMinField(Short value, short min, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        short data = value;
        if (data < min) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMinField(Date value, Date min) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        if (min.after(value)) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMinField(Date value, Date min, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        if (min.after(value)) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMinLengthField(String value, int minLength) throws SevenTeamException {
        if (value.length() >= minLength) {
            return;
        }
        throw new SevenTeamException.InvalidDataException("Invalid Min Length (" + minLength + ")");
    }

    public void validateMinLengthField(String value, int minLength, String message) throws SevenTeamException {
        if (value.length() >= minLength) {
            return;
        }
        throw new SevenTeamException.InvalidDataException(message);
    }

    public void validateMaxField(Long value, long max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        long data = value;
        if (data > max) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMaxField(Long value, long max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        long data = value;
        if (data > max) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMaxField(Integer value, int max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        int data = value;
        if (data > max) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMaxField(Integer value, int max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        int data = value;
        if (data > max) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMaxField(Short value, short max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        short data = value;
        if (data > max) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMaxField(Short value, short max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        short data = value;
        if (data > max) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMaxField(Date value, Date max) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException();
        }
        if (value.after(max)) {
            throw new SevenTeamException.InvalidDataException();
        }
    }

    public void validateMaxField(Date value, Date max, String message) throws SevenTeamException {
        if (value == null) {
            throw new SevenTeamException.NoDataException(message);
        }
        if (value.after(max)) {
            throw new SevenTeamException.InvalidDataException(message);
        }
    }

    public void validateMaxLengthField(String value, int maxLength) throws SevenTeamException {
        if (value.length() <= maxLength) {
            return;
        }
        throw new SevenTeamException.InvalidDataException("Invalid Max Length (" + maxLength + ")");
    }

    public void validateMaxLengthField(String value, int maxLength, String message) throws SevenTeamException {
        if (value.length() <= maxLength) {
            return;
        }
        throw new SevenTeamException.InvalidDataException(message);
    }
}

