package vn.kalapa.behaviorsdk.components

import android.content.Context


interface IKLPModule {
    //    var data: Map<String, Any>
    val key: String
    fun getRequirePermission(): Array<String>
    fun getPermissionAndNeededInfo(applicationContext: Context, completion: () -> Map<String, Any>): Map<String, Any>
    suspend fun setupCollectors(applicationContext: Context): Map<String, Any>
}

abstract class IKLPApplicationModule : IKLPModule {
    protected val APP_PACKAGES = mapOf(
        "com.discord" to "discord",
        "com.google.android.apps.meetings" to "gmeet",
        "vn.com.vng.zalopay" to "zalopay",
        "com.instagram.android" to "instagram",
        "com.mbmobile" to "mbbank",
        "vn.gov.mic.bluezone" to "vneid",
        "com.google.android.apps.translate" to "googletranslate",
        "com.linkedin.android" to "linkedin",
        "com.bac.ab" to "bnc",
        "com.zing.zalo" to "zalo",
        "com.fptplay" to "fptplay",
        "org.telegram.messenger" to "telegram",
        "com.booking" to "booking",
        "com.beekin.cake" to "cake-vn",
        "com.zhiliaoapp.musically" to "tiktok",
        "com.fcbarcelona" to "barcelona",
        "com.microsoft.office.powerpoint" to "powerpoint",
        "com.viettel.vtpay" to "viettelmoney",
        "com.microsoft.office.officehubrow" to "officemobile",
        "com.mservice.momotransfer" to "momo",
        "com.twitter.android" to "twitter",
        "com.VietinBank.ipay" to "vietinbankipay",
        "com.google.android.gm" to "googlegmail",
        "com.grabtaxi.passenger" to "grab",
        "com.whatsapp" to "whatsapp",
        "com.spotify.music" to "spotify",
        "xyz.be.customer" to "be",
        "com.vpb.neo" to "vpbankneo",
        "com.openai.chat" to "com-openai-chat",
        "us.zoom.videomeetings" to "zoomus",
        "com.agoda.mobile.consumer" to "agoda",
        "com.facebook.orca" to "fb-messenger",
        "com.facebook.katana" to "fb",
        "com.android.chrome" to "googlechrome",
        "com.google.android.apps.maps" to "comgooglemaps",
        "com.google.android.apps.docs" to "googledrive",
        "com.google.android.apps.dynamite" to "com-google-chat",
        "com.google.android.apps.docs.editors.sheets" to "googlesheets",
        "com.microsoft.teams" to "msteams",
        "com.skype.raider" to "skype",
        "com.techcombank.bb" to "tcb",
        "com.netflix.mediaclient" to "nflx",
        "com.microsoft.office.outlook" to "ms-outlook",
        "com.snapchat.android" to "snapchat",
        "com.google.android.apps.docs.editors.docs" to "googledocs",
        "com.google.android.apps.youtube.music" to "youtubemusic",
        "com.google.android.youtube" to "youtube",
        "com.shbmobile" to "shbmobile",
        "com.bidv.smartbanking" to "bidvsmartbanking",
        "com.microsoft.office.excel" to "excel"
    )

    protected fun convertMillisecondsToMinutes(x: Long): Int {
        return when (x) {
            0L -> 0
            in 1 until 60000 -> 1
            else -> (x / 60000).toInt()
        }
    }
}