package vn.kalapa.behaviorsdk.managers

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.isActive
import kotlinx.coroutines.launch
import vn.kalapa.behaviorsdk.utils.Helpers

class PeriodicTaskManager(private val doYourTask: suspend () -> Unit) {
    private val TAG = PeriodicTaskManager::class.java.simpleName
    private var taskJob: Job? = null
    private val coroutineScope = CoroutineScope(Dispatchers.IO)

    fun startPeriodicTask(interval: Long) {
        if (taskJob?.isActive == true) {
            Helpers.printLog("$TAG Task is already running!")
            return
        }

        taskJob = coroutineScope.launch {
            while (isActive) { // Ensure the loop stops when canceled
                Helpers.printLog("$TAG Executing task at ${System.currentTimeMillis()}")
                doYourTask()
                delay(interval * 1000)
            }
        }
    }

    fun stopPeriodicTask() {
        taskJob?.cancel()
        Helpers.printLog("$TAG Task stopped!")
    }

}