package vn.kalapa.behaviorsdk.views

import android.animation.ObjectAnimator
import android.animation.ValueAnimator
import android.app.Activity
import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.view.Window
import android.view.WindowManager
import android.view.animation.LinearInterpolator
import android.widget.ProgressBar
import android.widget.TextView
import vn.kalapa.behaviorsdk.R
import vn.kalapa.behaviorsdk.utils.Helpers

class ProgressView {
    enum class ProgressViewType {
        LOADING,
        COLLECTING,
        ANALYSING
    }

    companion object {
        private var startTime: Long = 0
        private var sDialog: Dialog? = null
        private var showing = false
        private var currentContextClass: String? = null
        private const val MINIMUM_ANIMATION_TIME = 3000

        fun showProgress(context: Context, progressType: ProgressViewType? = ProgressViewType.LOADING, mainColor: String? = null, mainTextColor: String? = null, title: String? = null, message: String? = null) {
            try {
                if (currentContextClass != context.javaClass.simpleName) {
                    sDialog?.dismiss()
                    sDialog = null
                    currentContextClass = context.javaClass.simpleName
                } else {
                    if (showing) {
                        Log.d("ProgressView", "One instance is showing...")
                        hideProgress(true)
                    }
                }
                startTime = System.currentTimeMillis()
                showing = true
                sDialog = Dialog(context)
                sDialog?.setOnDismissListener { showing = false }
                sDialog?.requestWindowFeature(Window.FEATURE_NO_TITLE)
                sDialog?.setContentView(R.layout.kalapa_progress_view)
                sDialog?.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
                sDialog?.window?.setLayout(
                    WindowManager.LayoutParams.MATCH_PARENT,
                    WindowManager.LayoutParams.MATCH_PARENT
                )
//                val progressBar = sDialog?.findViewById<View>(R.id.klp_progress_bar) as ProgressBar
//                setAnimate(progressBar)
                val textView: TextView = sDialog?.findViewById(R.id.klp_alert_title)!!
                val body: TextView = sDialog?.findViewById(R.id.klp_alert_message)!!

                Helpers.printLog("Title: $title - $message ")
                textView.text = title ?: if (progressType == ProgressViewType.COLLECTING) context.getString(R.string.klp_collecting) else
                    if (progressType == ProgressViewType.ANALYSING) context.getString(R.string.klp_analyzing) else context.getString(R.string.klp_alert_title)
                body.text = message ?: if (progressType == ProgressViewType.COLLECTING) context.getString(R.string.klp_collecting_message) else
                    if (progressType == ProgressViewType.ANALYSING) context.getString(R.string.klp_analyzing_message) else context.getString(R.string.klp_please_wait)

                mainTextColor?.let {
                    textView.setTextColor(Color.parseColor(mainTextColor))
                    body.setTextColor(Color.parseColor(mainTextColor))
                }
                if (!title.isNullOrEmpty())
                    textView.text = title
                if (!message.isNullOrEmpty())
                    body.text = message
//                mainColor?.let { progressBar.indeterminateTintList = ColorStateList.valueOf(Color.parseColor(mainColor)) }

                sDialog?.setCancelable(false)
                Handler().postDelayed({ sDialog?.setCancelable(true) }, 5000)
                sDialog?.show()
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        private fun dismissThenInvoke(completion: (() -> Unit)?) {
            sDialog?.dismiss()
            sDialog = null
            completion?.invoke()
        }


        fun hideProgress(forceClose: Boolean = false, completion: (() -> Unit)? = null) {
            try {
                showing = false
                if (sDialog != null && sDialog!!.isShowing) {
                    val distanceTime = System.currentTimeMillis() - startTime
                    if (forceClose || (distanceTime > MINIMUM_ANIMATION_TIME)) {
                        dismissThenInvoke(completion)
                    } else {
                        Handler(Looper.getMainLooper()).postDelayed({
                            dismissThenInvoke(completion)
                        }, MINIMUM_ANIMATION_TIME - distanceTime)
                    }

                }
            } catch (e: Exception) {
                Helpers.printLog("Ignore hide progress exception")
            }

        }

        private fun setAnimate(progressBar: ProgressBar) {
            Helpers.printLog("Setting Animate...")
            // Set initial progress to 0
            progressBar.progress = 0
            // Animate the progress (0 to 100)
            val progressAnimator = ObjectAnimator.ofInt(progressBar, "progress", 0, 100)
            progressAnimator.duration = 2000 // 2 seconds for a full rotation
            progressAnimator.interpolator = LinearInterpolator() // Smooth animation

            // Repeat the animation indefinitely to simulate a loading effect
            progressAnimator.repeatCount = ValueAnimator.INFINITE
            progressAnimator.start()
        }
    }
}

