package vn.kalapa.behaviorsdk.components

import android.Manifest
import android.app.Activity
import android.content.Context
import android.content.pm.PackageManager
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.os.Build
import vn.kalapa.behaviorsdk.service.getPackageInfo

class KLPApplicationModule : IKLPApplicationModule() {
    override val key: String
        get() = "application"

    override fun getRequirePermission(): Array<String> {
        return arrayOf(
            Manifest.permission.READ_PHONE_STATE
        )
    }

    private val APPLICATION_INSTALLED_APPS = "installed_apps"
    private val APPLICATION_IS_VPN_ACTIVE = "is_VPN_active"
    val data = HashMap<String, Any>()


    override fun getPermissionAndNeededInfo(applicationContext: Context, completion: () -> Map<String, Any>): Map<String, Any> {
        return completion()
    }

    override suspend fun setupCollectors(applicationContext: Context): Map<String, Any> {
        return getPermissionAndNeededInfo(applicationContext, completion = {
            data[key] = mapOf(
                APPLICATION_INSTALLED_APPS to getInstalledApps(applicationContext),
                APPLICATION_IS_VPN_ACTIVE to isVpnActive(applicationContext)
            )
            data
        })
    }

    private fun getInstalledApps(context: Context): Map<String, Boolean> {
        val mapOf = mutableMapOf<String, Boolean>()
        APP_PACKAGES.forEach {
            mapOf[it.value] = isAppInstalled(context, it.key)
        }
        return mapOf
    }

    private fun isAppInstalled(context: Context, packageName: String): Boolean {
        return try {
            context.getPackageInfo(packageName)
            true
        } catch (e: PackageManager.NameNotFoundException) {
//            Helpers.printLog(e)
//            e.printStackTrace()
            false
        }
    }

    private fun isVpnActive(context: Context): Boolean {
        val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val network = connectivityManager.activeNetwork ?: return false
            val capabilities = connectivityManager.getNetworkCapabilities(network) ?: return false
            return capabilities.hasTransport(NetworkCapabilities.TRANSPORT_VPN)
        } else {
            // For older versions below Android M (Marshmallow)
            @Suppress("DEPRECATION")
            val activeNetworkInfo = connectivityManager.activeNetworkInfo ?: return false
            @Suppress("DEPRECATION")
            return activeNetworkInfo.type == ConnectivityManager.TYPE_VPN
        }
    }
}