package vn.kalapa.behaviorsdk.models

import org.json.JSONObject


data class KLPBehaviorScoreResult(val result: KLPBehaviorScoreResponse, val permissions: Map<String, Boolean>)
data class KLPBehaviorScoreResponse(val code: String, val message: String, val data: KLPBehaviorResult)

data class KLPBehaviorResult(val code: String, val message: String, val dataset: KLPBehaviorDataset, val score: KLPBehaviorScoreObj, val num_features: Int, val risks: Int, val score_percentile: Float)

data class KLPBehaviorScoreObj(val overall: Int, val components: KLPBehaviorComponentScore)

data class KLPBehaviorComponentScore(val identity: Int, val device: Int, val network: Int, val behavior: Int, val fraud: Int)

data class KLPBehaviorDataset(val id: String)

object PERMISSION {
    val CONTACTS = "CONTACTS"
    val MEDIA = "MEDIA"
    val DEVICE = "DEVICE"
    val CALL = "CALL"
    val SMS = "SMS"
    val CALENDAR = "CALENDAR"
    val BLUETOOTH = "BLUETOOTH"
    val LOCATION = "LOCATION"
}


data class AppToken(val data: AppTokenData, val message: String, val code: Int) {
    companion object {
        fun fromJson(jsonString: String): AppToken {
            val jsonObject = JSONObject(jsonString)

            val data = if (jsonObject.has("data") && !jsonObject.isNull("data")) {
                val dataObject = jsonObject.getJSONObject("data")
                AppTokenData(dataObject.getString("access_token"))
            } else {
                throw IllegalArgumentException("Missing 'data' field in JSON")
            }

            return AppToken(
                data = data,
                message = jsonObject.getString("message"),
                code = jsonObject.getInt("code")
            )
        }
    }

    fun toJson(): String {
        val jsonObject = JSONObject()
            .put("message", message)
            .put("code", code)
            .put("data", JSONObject().put("access_token", data.access_token))

        return jsonObject.toString()
    }
}

data class AppTokenData(val access_token: String)
data class SubmitDataResponse(val data: SubmitDataDocID? = null, val code: Int, val message: String) {
    companion object {
        fun fromJson(jsonString: String): SubmitDataResponse {
            val jsonObject = JSONObject(jsonString)

            val data = if (jsonObject.has("data")) {
                val dataObject = jsonObject.getJSONObject("data")
                SubmitDataDocID(dataObject.getString("doc_id"))
            } else {
                null
            }

            return SubmitDataResponse(
                data = data,
                code = jsonObject.getInt("code"),
                message = jsonObject.getString("message")
            )
        }
    }

    fun toJson(): String {
        val jsonObject = JSONObject()
            .put("code", code)
            .put("message", message)

        data?.let {
            jsonObject.put("data", JSONObject().put("doc_id", it.doc_id))
        }

        return jsonObject.toString()
    }


}


data class KLPPair<T>(val first: T, val second: T) {
    fun toJson(): JSONObject {
        return JSONObject().apply {
            put("first", first)
            put("second", second)
        }
    }
}

data class SubmitDataDocID(val doc_id: String)