package vn.kalapa.behaviorsdk.utils

import android.app.Activity
import android.app.AlertDialog
import android.content.Context
import android.util.Log
import java.lang.Exception
import org.bouncycastle.jce.provider.BouncyCastleProvider
import org.bouncycastle.util.io.pem.PemReader
import java.io.StringReader
import java.security.KeyFactory
import java.security.Security
import java.security.spec.X509EncodedKeySpec
import javax.crypto.Cipher

class Helpers {

    companion object {
        private const val TAG = "KLP"
        fun printLog(vararg message: String) {
            Log.d(TAG, message.joinToString(" "))
        }

        fun printLog(exception: Exception) {
            Log.d(TAG, exception.message ?: exception.localizedMessage ?: exception.javaClass.name)
        }

        fun showDialog(context: Context, title: String = "Alert", message: String, onYes: (() -> Unit)? = null) {
            val builder = AlertDialog.Builder(context)
            builder.setTitle(title)
            builder.setMessage(message)
            onYes?.let {
                builder.setPositiveButton("OK") { dialog, _ ->
                    it()
                    dialog.dismiss()
                }
            }


            builder.setNegativeButton(if (onYes != null) "Cancel" else "OK") { dialog, _ ->
                dialog.dismiss()
            }
            val alertDialog = builder.create()
            alertDialog.show()
        }

    }
}