package vn.kalapa.behaviorsdk.behavioral

import android.app.Service
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.content.pm.PackageManager
import android.os.Build
import android.os.IBinder
import android.util.Log
import androidx.annotation.RequiresApi
import vn.kalapa.behaviorsdk.utils.Helpers

class PermissionRequestService : Service() {
    companion object {

    }

    private val TAG = this.javaClass.simpleName
    override fun onBind(intent: Intent?): IBinder? {
        return null
    }

    private val permissionReceiver = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            val grantResults = intent?.getIntArrayExtra(PermissionProxyActivity.EXTRA_GRANT_RESULTS)
            if (grantResults != null && grantResults.all { it == PackageManager.PERMISSION_GRANTED }) {
                // All permissions granted, proceed with the task
                Helpers.printLog(TAG, "Permissions granted")
            } else {
                // Permission denied, handle the denial case
                Log.d(TAG, "Permissions denied")
            }
            stopSelf() // Stop the service once we have the result
        }
    }

    @RequiresApi(Build.VERSION_CODES.TIRAMISU)
    override fun onCreate() {
        super.onCreate()
        // Register receiver to listen for permission result
        val filter = IntentFilter(PermissionProxyActivity.ACTION_PERMISSION_RESULT)
        registerReceiver(permissionReceiver, filter, RECEIVER_NOT_EXPORTED)
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        // Trigger the permission request using the Proxy Activity
        val permissions = intent?.getStringArrayExtra(PermissionProxyActivity.EXTRA_PERMISSIONS)
//        val permissions = arrayOf(
//            Manifest.permission.READ_CALENDAR,
//            Manifest.permission.WRITE_CALENDAR
//        )
        Helpers.printLog("$TAG onStartCommand: $permissions")
        if (permissions != null) {
            PermissionProxyActivity.start(this, permissions)
        }
        return START_NOT_STICKY
    }

    override fun onDestroy() {
        super.onDestroy()
        // Unregister the broadcast receiver when the service is destroyed
        unregisterReceiver(permissionReceiver)
    }

}