package vn.kalapa.behaviorsdk.behavioral.viewhandler

import android.annotation.SuppressLint
import android.view.MotionEvent
import android.widget.Button
import vn.kalapa.behaviorsdk.components.KLPBehavioralModule
import vn.kalapa.behaviorsdk.models.KLPBehaviorObject
import vn.kalapa.behaviorsdk.utils.Common

class ButtonViewHandler(private val v: Button, private val path: String) : DefaultViewHandler(v, path) {
    @SuppressLint("ClickableViewAccessibility")
    override fun handle() {
        v.setOnTouchListener { btn, motionEvent ->
            if (motionEvent.action == MotionEvent.ACTION_UP) {
                val resourceName = Common.getKLPFormatResourcesName(v)
                val klpBehavior = KLPBehaviorObject.KLPBehaviorClick(
                    path,
                    KLPBehaviorObject.KLPBehaviorPosition(btn.x.toInt(), btn.y.toInt())
                )
                KLPBehavioralModule.addBehavior(klpBehavior)
            }
            false
        }
    }
}