package vn.kalapa.behaviorsdk.managers

import android.content.pm.PackageManager
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import vn.kalapa.behaviorsdk.utils.Common.Companion.getArrayOfPermission


interface KLPPermissionHandler {
    fun onPermissionGranted()
    fun onPermissionDenied()
}

class PermissionFragment : Fragment() {
    private var permissionResultCallback: ((Boolean) -> Unit)? = null

    companion object {
        private const val REQUEST_CODE = 188

        fun newInstance(): PermissionFragment {
            return PermissionFragment()
        }
    }

    private var permissionCallback: KLPPermissionHandler? = null

    fun requestPermission(requestPermission: Array<String>, callback: (Boolean) -> Unit) {
        var isAllGranted = true
        permissionResultCallback = callback
        for (permission in getArrayOfPermission()) {
            if (ContextCompat.checkSelfPermission(requireContext(), permission) != PackageManager.PERMISSION_GRANTED) {
//                requestPermissions(if (requestPermission.isNotEmpty()) requestPermission else getArrayOfPermission(), REQUEST_CODE)
                requestPermissions(requestPermission, REQUEST_CODE)
                isAllGranted = false
                break
            }
        }
        if (isAllGranted) // Khi ta
            callback(true)

    }

    @Deprecated("Deprecated in Java")
    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<out String>, grantResults: IntArray) {
        if (requestCode == REQUEST_CODE) {
            if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                permissionResultCallback?.invoke(true)
            } else {
                permissionResultCallback?.invoke(false)
            }
        }
    }

    override fun onDetach() {
        super.onDetach()
        permissionCallback = null
    }
}

class PermissionRequester(private val fragmentManager: FragmentManager) {

    private var permissionFragment: PermissionFragment? = null

    init {
        // Try to find the fragment if it already exists
        permissionFragment = fragmentManager.findFragmentByTag("PermissionFragment") as? PermissionFragment
        if (permissionFragment == null) {
            permissionFragment = PermissionFragment.newInstance()
            fragmentManager
                .beginTransaction()
                .add(permissionFragment!!, "PermissionFragment")
                .commitNow()
        }
    }

    // Call this method to request permission
    fun requestPermission(permission: Array<String>, callback: (Boolean) -> Unit) {
        permissionFragment?.requestPermission(permission, callback)
    }
}