package vn.kalapa.behaviorsdk.models

import android.annotation.SuppressLint
import android.content.Context
import android.provider.Settings
import vn.kalapa.behaviorsdk.managers.UUIDManager
import vn.kalapa.behaviorsdk.managers.UUIDManager.getDeviceId
import vn.kalapa.behaviorsdk.utils.Helpers
import vn.kalapa.behaviorsdk.utils.KLPBehaviorConfig
import java.security.MessageDigest

class KLPTelephonyInfo private constructor(val isRoamingEnabled: Boolean, val isDataEnabled: Boolean, val uniqueDeviceId: String, val gaDeviceId: String, val agDeviceId: String, val sDeviceId: String, val simNumber1: String, val simOperator1: String, val simCountryISO: String) {

    class KLPTelephonyInfoBuilder {
        private var isRoamingEnabled: Boolean = false
        private var isDataEnabled: Boolean = false
        private var uniqueDeviceId: String = KLPBehaviorConfig.NA
        private var agDeviceId: String = KLPBehaviorConfig.NA
        private var sDeviceId: String = KLPBehaviorConfig.NA
        private var gaDeviceId: String = KLPBehaviorConfig.NA
        private var simNumber: String = KLPBehaviorConfig.NA
        private var simOperator: String = KLPBehaviorConfig.NA
        private var simCountryISO: String = KLPBehaviorConfig.NA
        fun withIsRoamingEnabled(isRoamingEnabled: Boolean): KLPTelephonyInfoBuilder {
            this.isRoamingEnabled = isRoamingEnabled
            return this
        }

        fun withSimCountryISO(simCountryISO: String): KLPTelephonyInfoBuilder {
            this.simCountryISO = simCountryISO
            return this
        }


        fun withDataEnabled(isDataEnabled: Boolean): KLPTelephonyInfoBuilder {
            this.isDataEnabled = isDataEnabled
            return this
        }

        fun withUniqueDeviceId(context: Context): KLPTelephonyInfoBuilder {
            this.uniqueDeviceId = getUniqueAppDeviceId(context)
            this.sDeviceId = md5Hash(getSDeviceId(context))
            this.gaDeviceId = UUIDManager.getGADeviceId(context)?.let {
                md5Hash(it)
            } ?: KLPBehaviorConfig.NA
            this.agDeviceId = md5Hash(getDeviceId())
            Helpers.printLog("Common: uniqueDeviceId: $uniqueDeviceId sDeviceId: $sDeviceId gaDeviceId: $gaDeviceId agDeviceId: $agDeviceId")
            return this
        }

        @SuppressLint("HardwareIds")
        private fun getSDeviceId(context: Context): String {
            return Settings.Secure.getString(context.contentResolver, Settings.Secure.ANDROID_ID) // Deprecated since 1.0.3.5
        }

        private fun getUniqueAppDeviceId(context: Context): String {
            val uniqueDeviceID = UUIDManager.getOrSetUUID(context)
            val hashUuid = md5Hash(uniqueDeviceID)
            return hashUuid
        }


        private fun md5Hash(input: String): String {
            val md = MessageDigest.getInstance("MD5")
            val digest = md.digest(input.toByteArray(Charsets.UTF_8))
            return digest.joinToString("") { "%02x".format(it) } // Convert to hex string
        }


        fun withSimNumber1(simNumber1: String): KLPTelephonyInfoBuilder {
            this.simNumber = simNumber1
            return this
        }


        fun withSimOperator1(simOperator1: String): KLPTelephonyInfoBuilder {
            this.simOperator = simOperator1
            return this
        }


        fun build(): KLPTelephonyInfo {
            return KLPTelephonyInfo(isRoamingEnabled, isDataEnabled, uniqueDeviceId, gaDeviceId, agDeviceId, sDeviceId, simNumber, simOperator, simCountryISO)
        }
    }
}

