package vn.kalapa.behaviorsdk.utils

import android.Manifest
import android.app.Activity
import android.content.Context
import android.content.pm.PackageManager
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat

class PermissionUtils {
    companion object {
        val PERMISSION_CONTACT_READ_CONTACT = Manifest.permission.READ_CONTACTS
        val PERMISSION_TELEPHONY_READ_PHONE_STATE = Manifest.permission.READ_PHONE_STATE
        private var declineCount = 0

        fun isPermissionGranted(permission: String) {

        }

        private fun allPermissionsGranted(baseContext: Context, requiredPermission: List<String>) = requiredPermission.all {
            ContextCompat.checkSelfPermission(baseContext, it) == PackageManager.PERMISSION_GRANTED
        }

//        private val activityResultLauncher =
//            registerForActivityResult(ActivityResultContracts.RequestMultiplePermissions()) { permissions ->
//                // Handle Permission granted/rejected
//                var permissionGranted = true
//                permissions.entries.forEach {
//                    if (it.key in REQUIRED_PERMISSIONS && !it.value)
//                        permissionGranted = false
//                }
//                if (!permissionGranted) {
//                    Toast.makeText(
//                        baseContext,
//                        "Permission request denied",
//                        Toast.LENGTH_SHORT
//                    ).show()
//                } else {
//                    startCamera()
//                }
//            }

        private fun isPermissionGranted(activity: Activity, permission: String, onApproved: () -> Unit, onDeclined: () -> Unit) {
            if (allPermissionsGranted(activity, listOf(permission))) {
                Helpers.printLog("allPermissionsGranted - startCamera")
                onApproved()
            } else {
                if (ActivityCompat.checkSelfPermission(activity, permission) != PackageManager.PERMISSION_GRANTED) {
                    // Permission is not granted
                    // Show an explanation to the user *asynchronously*
                    // After the user sees the explanation, try again to request the permission.
                    if (ActivityCompat.shouldShowRequestPermissionRationale(activity, permission))
                        askToGoToSetting(onDeclined)
                    else {
                        // No explanation needed; request the permission
                        declineCount++
                        if (declineCount < 3)
                            requestPermissions()
                        else
                            askToGoToSetting(onDeclined)
                    }
                } else {
                    // Permission has already been granted
                    onApproved()
                    Helpers.printLog("allPermissionsGranted - startCamera")
                }
            }
        }

        private fun requestPermissions() {

        }

        private fun askToGoToSetting(onDeclined: () -> Unit) {
            // If they deny
        }
    }

}