package vn.kalapa.behaviorsdk.behavioral.viewhandler

import android.annotation.SuppressLint
import android.view.MotionEvent
import android.view.SurfaceView
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import vn.kalapa.behaviorsdk.components.KLPBehavioralModule
import vn.kalapa.behaviorsdk.models.KLPBehaviorObject
import vn.kalapa.behaviorsdk.utils.Helpers
import java.lang.reflect.Field
import kotlin.math.pow
import kotlin.math.sqrt

open class DefaultViewHandler(private val view: View, private val path: String) : IViewHandler {
    val TAG = "IViewHandler ${this.javaClass.simpleName}"
    private var start: Long = System.currentTimeMillis()
    private val MIN_SWIPE_DISTANCE = 20 // Pixels
    private var movePosition: KLPBehaviorObject.KLPBehaviorPosition? = null
    override fun handleClick(): Boolean {
        return false
    }

    override fun handleTouch(event: MotionEvent): Boolean {
        return false
    }


    @SuppressLint("ClickableViewAccessibility")
    override fun handle() {
        if (view !is ViewGroup || view.childCount == 1) {
            view.setOnTouchListener { _, event ->
                val position = KLPBehaviorObject.KLPBehaviorPosition(event.x.toInt(), event.y.toInt())

                when (event.action) {
                    MotionEvent.ACTION_DOWN -> {
                        Helpers.verbose("on MotionEvent.ACTION_DOWN id  ${view.javaClass.simpleName} ${view.id} - ${view::class.java.simpleName} - is ViewGroup: ${view is ViewGroup}")
                        if (view.javaClass.simpleName.contains("Flutter"))
                            false
                        (view as? ViewGroup)?.let { v ->
                            Helpers.verbose("on MotionEvent.ACTION_DOWN View ${v.javaClass.simpleName} ${v.id} is a ViewGroup and has ${v.childCount} children")
                        }
                        start = System.currentTimeMillis()
                        movePosition = null
                        if (view is SurfaceView || (view is ViewGroup && view.childCount == 1) || view.javaClass.simpleName.contains("Flutter")) false else true // Let other listeners also handle the event
                    }

                    MotionEvent.ACTION_MOVE -> {
                        if (movePosition == null) {
                            movePosition = position
                        }
                        false
                    }

                    MotionEvent.ACTION_UP -> {
                        if (view is ViewGroup) {
                            Helpers.verbose("on MotionEvent.ACTION_UP View ${view.javaClass.simpleName} ${view.id} and has ${view.childCount}")
                        } else {
                            Helpers.verbose("on MotionEvent.ACTION_UP View ${view.javaClass.simpleName} ${view.id}")
                        }
                        val distance = movePosition?.let {
                            calculateDistance(it.x, it.y, position.x, position.y)
                        } ?: 0

                        if (distance < MIN_SWIPE_DISTANCE) {
                            // Ensure normal button clicks work
                            view.performClick()
                            KLPBehavioralModule.addBehavior(KLPBehaviorObject.KLPBehaviorClick(path, position))
                        } else {
                            KLPBehavioralModule.addBehavior(
                                KLPBehaviorObject.KLPBehaviorPointer(
                                    path, (System.currentTimeMillis() - start),
                                    distance,
                                    arrayOf(movePosition!!, position)
                                )
                            )
                        }
                        movePosition = null
                        false // Allow button click events to propagate
                    }

                    else -> false
                }
            }
        }
    }

    private fun getActionName(action: Int): String {
        return when (action) {
            MotionEvent.ACTION_DOWN -> "ACTION_DOWN"
            MotionEvent.ACTION_UP -> "ACTION_UP"
            MotionEvent.ACTION_MOVE -> "ACTION_MOVE"
            MotionEvent.ACTION_CANCEL -> "ACTION_CANCEL"
            MotionEvent.ACTION_OUTSIDE -> "ACTION_OUTSIDE"
            MotionEvent.ACTION_POINTER_DOWN -> "ACTION_POINTER_DOWN"
            MotionEvent.ACTION_POINTER_UP -> "ACTION_POINTER_UP"
            MotionEvent.ACTION_HOVER_MOVE -> "ACTION_HOVER_MOVE"
            MotionEvent.ACTION_SCROLL -> "ACTION_SCROLL"
            MotionEvent.ACTION_HOVER_ENTER -> "ACTION_HOVER_ENTER"
            MotionEvent.ACTION_HOVER_EXIT -> "ACTION_HOVER_EXIT"
            else -> "UNKNOWN_ACTION"
        }
    }

    private fun calculateDistance(x1: Float, y1: Float, x2: Float, y2: Float): Int {
        return (sqrt((x2 - x1).pow(2) + (y2 - y1).pow(2))).toInt()
    }

    private fun calculateDistance(x1: Int, y1: Int, x2: Int, y2: Int): Int {
        return (sqrt((x2 - x1).toFloat().pow(2) + (y2 - y1).toFloat().pow(2))).toInt()
    }

}
