package vn.kalapa.behaviorsdk.components

import android.Manifest
import android.app.Activity
import android.content.Context
import android.database.Cursor
import android.provider.ContactsContract
import vn.kalapa.behaviorsdk.utils.Common
import vn.kalapa.behaviorsdk.utils.Helpers

// done
class KLPContactModule(private val collectFullInformation: Boolean = false) : IKLPModule {
    private val CONTACT_COUNT = "contacts_count"
    private val CONTACT_PHONE_NUMBER_COUNT = "phone_numbers_count"
    private val CONTACT_EMAIL_COUNT = "contacts_with_email_count"
    private val CONTACT_LINKED_SKYPE = "contacts_linked_to_skype_count"
    private val CONTACT_LINKED_ZALO = "contacts_linked_to_zalo_count"
    private val CONTACT_LINKED_SHOPEE = "contacts_linked_to_shopee_count"
    private val CONTACT_LINKED_FACEBOOK = "contacts_linked_to_facebook_count"
    private val CONTACT_LINKED_MESSENGER = "contacts_linked_to_messenger_count"
    private val CONTACT_LINKED_TELEGRAM = "contacts_linked_to_telegram_count"
    private val CONTACT_LINKED_SLACK = "contacts_linked_to_slack_count"
    private val CONTACT_LINKED_TIKTOK = "contacts_linked_to_tiktok_count"
    private val CONTACT_LINKED_WHATSAPP = "contacts_linked_to_whatsapp_count"
    private val CONTACT_WITH_PICTURE_COUNT = "contacts_with_pictures_count"
    private val CONTACT_WITH_MULTIPLE_NUMBERS_COUNT = "contacts_has_multiple_numbers_count"
    private val CONTACT_DETAILS = "contacts"

    private val KEY_PHONE_NUMBER = "phone_number"
    private val MIME_FACEBOOK = "vnd.android.cursor.item/vnd.com.facebook.profile"
    private val MIME_TELEGRAM = "vnd.android.cursor.item/vnd.org.telegram.messenger"
    private val MIME_SLACK = "vnd.android.cursor.item/vnd.com.slack.profile"
    private val MIME_MESSENGER = "vnd.android.cursor.item/vnd.com.facebook.orca"
    private val MIME_TIKTOK = "vnd.android.cursor.item/vnd.com.zhiliaoapp.musically.profile"
    private val MIME_SHOPEE = "vnd.android.cursor.item/vnd.com.shopee.profile"
    private val MIME_ZALO = "vnd.android.cursor.item/com.zing.zalo.call"
    private val MIME_SKYPE = "vnd.android.cursor.item/vnd.com.skype.android.skypecall"
    private val MIME_WHATSAPP = "vnd.android.cursor.item/vnd.com.whatsapp.profile"

    override val key: String
        get() = "contact"

    override fun getPermissionAndNeededInfo(applicationContext: Context, completion: () -> Map<String, Any>): Map<String, Any> {
        return if (Common.checkIfPermissionGranted(applicationContext, Manifest.permission.READ_CONTACTS))
            completion()
        else mapOf()
    }

    override fun getRequirePermission(): Array<String> {
        return arrayOf(Manifest.permission.READ_CONTACTS, Manifest.permission.READ_PHONE_STATE)
    }

    private val data: HashMap<String, Any> = HashMap()
    override suspend fun setupCollectors(applicationContext: Context): Map<String, Any> {
        Helpers.printLog("KLPContactComponent setupCollectors... ")
        return getPermissionAndNeededInfo(applicationContext, completion = {
            val contactList = getContacts(applicationContext)
            val notANumberList = ArrayList<String>()
            var emailList = getEmails(applicationContext)
            var numberCount = 0
            var photoCount = 0
            var multipleNumberCount = 0

            contactList.forEach { contactNumber ->
                val numbers = contactNumber[KEY_PHONE_NUMBER] as? List<String> ?: run {
                    Helpers.printLog("KLPContactModule Not contains numbers: $contactNumber")
                    return@forEach
                }

                val validNumbers = numbers.filter { number -> Common.mostLikelyPhoneNumber(number) }

                if (validNumbers.isNotEmpty()) {
                    numberCount++
                    if (validNumbers.size > 1) multipleNumberCount++
                }

                if (contactNumber.containsKey("photo"))
                    photoCount++
            }

            data[CONTACT_COUNT] = contactList.size
            data[CONTACT_PHONE_NUMBER_COUNT] = numberCount
            data[CONTACT_EMAIL_COUNT] = emailList.size
            data[CONTACT_LINKED_SKYPE] = getMimeContacts(applicationContext, MIME_SKYPE).size
            data[CONTACT_LINKED_ZALO] = getMimeContacts(applicationContext, MIME_ZALO).size
            data[CONTACT_LINKED_FACEBOOK] = getMimeContacts(applicationContext, MIME_FACEBOOK).size
            data[CONTACT_LINKED_MESSENGER] = getMimeContacts(applicationContext, MIME_MESSENGER).size
            data[CONTACT_LINKED_TELEGRAM] = getMimeContacts(applicationContext, MIME_TELEGRAM).size
            data[CONTACT_LINKED_SLACK] = getMimeContacts(applicationContext, MIME_SLACK).size
            data[CONTACT_LINKED_TIKTOK] = getMimeContacts(applicationContext, MIME_TIKTOK).size
            data[CONTACT_LINKED_SHOPEE] = getMimeContacts(applicationContext, MIME_SHOPEE).size
            data[CONTACT_LINKED_WHATSAPP] = getMimeContacts(applicationContext, MIME_WHATSAPP).size
            data[CONTACT_WITH_PICTURE_COUNT] = photoCount
            data[CONTACT_WITH_MULTIPLE_NUMBERS_COUNT] = multipleNumberCount
            if (collectFullInformation) data[CONTACT_DETAILS] = contactList

//            Helpers.printLog("CONTACT_COUNT ${data[CONTACT_COUNT].toString()}")
//            Helpers.printLog("PHONE_NUMBER_COUNT ${data[CONTACT_PHONE_NUMBER_COUNT].toString()}")
//            Helpers.printLog("CONTACT_EMAIL_COUNT ${data[CONTACT_EMAIL_COUNT].toString()}")
//            Helpers.printLog("CONTACT_LINKED_ZALO ${data[CONTACT_LINKED_ZALO].toString()}")
//            Helpers.printLog("CONTACT_LINKED_SKYPE ${data[CONTACT_LINKED_SKYPE].toString()}")
//            Helpers.printLog("CONTACT_LINKED_FACEBOOK ${data[CONTACT_LINKED_FACEBOOK].toString()}")
//            Helpers.printLog("CONTACT_LINKED_MESSENGER ${data[CONTACT_LINKED_MESSENGER].toString()}")
//            Helpers.printLog("CONTACT_LINKED_TELEGRAM ${data[CONTACT_LINKED_TELEGRAM].toString()}")
//            Helpers.printLog("CONTACT_LINKED_SLACK ${data[CONTACT_LINKED_SLACK].toString()}")
//            Helpers.printLog("CONTACT_LINKED_TIKTOK ${data[CONTACT_LINKED_TIKTOK].toString()}")
//            Helpers.printLog("CONTACT_LINKED_SHOPEE ${data[CONTACT_LINKED_SHOPEE].toString()}")
//            Helpers.printLog("CONTACT_LINKED_WHATSAPP ${data[CONTACT_LINKED_WHATSAPP].toString()}")
//            Helpers.printLog("CONTACT_WITH_PICTURE_COUNT ${data[CONTACT_WITH_PICTURE_COUNT].toString()}")
//            Helpers.printLog("CONTACT_WITH_MULTIPLE_NUMBERS_COUNT ${data[CONTACT_WITH_MULTIPLE_NUMBERS_COUNT].toString()}")
            mapOf(key to data)
        })
    }

    private fun getContacts(context: Context): List<Map<String, Any>> {
        val contactsList = mutableListOf<Map<String, Any>>()

        // Define the columns to retrieve
        val projection = arrayOf(
            ContactsContract.CommonDataKinds.Phone.DISPLAY_NAME,
            ContactsContract.CommonDataKinds.Phone.NUMBER,
            ContactsContract.CommonDataKinds.Phone.CONTACT_ID,
            ContactsContract.CommonDataKinds.Phone.PHOTO_URI
        )

        // Query the contacts
        val cursor = context.contentResolver.query(
            ContactsContract.CommonDataKinds.Phone.CONTENT_URI,
            projection,
            null,
            null,
            ContactsContract.CommonDataKinds.Phone.DISPLAY_NAME + " ASC"
        )

        cursor?.use {
            val contactMap = mutableMapOf<Long, MutableMap<String, Any>>()
            val contactIdIndex = it.getColumnIndex(ContactsContract.CommonDataKinds.Phone.CONTACT_ID)
            val nameIndex = it.getColumnIndex(ContactsContract.CommonDataKinds.Phone.DISPLAY_NAME)
            val numberIndex = it.getColumnIndex(ContactsContract.CommonDataKinds.Phone.NUMBER)
            val photoUriIndex = it.getColumnIndex(ContactsContract.CommonDataKinds.Phone.PHOTO_URI)

            while (it.moveToNext()) {
                val contactId = it.getLong(contactIdIndex)
                val name = it.getString(nameIndex)
                val number = it.getString(numberIndex)
                val photoUri = it.getString(photoUriIndex)

                // Check if this contact is already in the map
                if (!contactMap.containsKey(contactId)) {
                    contactMap[contactId] = mutableMapOf(
                        "name" to name,
                        KEY_PHONE_NUMBER to mutableListOf<String>(),
                    )
                    if (photoUri != null)
                        contactMap[contactId]?.set("photo", "")
//                        Helpers.printLog("photoUriIndex $photoUri")
//                    }
                }
//                if (name.contains("Someone")) Helpers.printLog("contactMap[contactId] ${contactMap[contactId]}")
                // Add the number to the contact's list of numbers
                (contactMap[contactId]?.get(KEY_PHONE_NUMBER) as MutableList<String>).add(normalizePhoneNumber(number))
            }

            // Add all the contacts to the final list
            contactsList.addAll(contactMap.values)
        }
        return contactsList

    }

    private fun normalizePhoneNumber(phoneNumber: String): String {
        return phoneNumber.replace(" ", "").replace("-", "").replace("+84", "0")
    }

    private fun getEmails(context: Context): List<Map<String, String>> {
        val contactsList = mutableListOf<Map<String, String>>()

        // Define the columns to retrieve
        val projection = arrayOf(
            ContactsContract.CommonDataKinds.Email.DISPLAY_NAME,
            ContactsContract.CommonDataKinds.Email.ADDRESS,
            ContactsContract.CommonDataKinds.Email.CONTACT_ID
        )

        // Query the contacts
        val cursor = context.contentResolver.query(
            ContactsContract.CommonDataKinds.Email.CONTENT_URI,
            projection,
            null,
            null,
            null
        )

        // Iterate through the cursor and extract the contact names and phone numbers
        cursor?.use {
            val nameIndex = it.getColumnIndex(ContactsContract.CommonDataKinds.Email.DISPLAY_NAME)
            val emailIndex = it.getColumnIndex(ContactsContract.CommonDataKinds.Email.ADDRESS)
            val contactIdIndex = it.getColumnIndex(ContactsContract.CommonDataKinds.Email.CONTACT_ID)

            while (it.moveToNext()) {
                val name = it.getString(nameIndex)
                val email = it.getString(emailIndex)
                val contact = mapOf("name" to name, "email" to email, "index" to contactIdIndex.toString())
//                Helpers.printLog("Email $contact")
                contactsList.add(contact)
            }
        }
        return contactsList
    }

    private fun getMimeContacts(context: Context, mimeType: String): List<Map<String, String>> {
        val mimeContacts = mutableListOf<Map<String, String>>()

        // The MIMETYPE for Skype might look something like this (example):

        // Define the projection (columns to retrieve)
        val projection = arrayOf(
            ContactsContract.Data.DISPLAY_NAME,
            ContactsContract.Data.DATA1,  // Usually the primary data field
            ContactsContract.Data.CONTACT_ID
        )

        // Query the ContactsContract.Data table
        val cursor: Cursor? = context.contentResolver.query(
            ContactsContract.Data.CONTENT_URI,
            projection,
            ContactsContract.Data.MIMETYPE + " = ?",
            arrayOf(mimeType),
            null
        )

        cursor?.use {
            val nameIndex = it.getColumnIndex(ContactsContract.Data.DISPLAY_NAME)
            val dataIndex = it.getColumnIndex(ContactsContract.Data.DATA1)
            val contactIdIndex = it.getColumnIndex(ContactsContract.Data.CONTACT_ID)

            while (it.moveToNext()) {
                val name = it.getString(nameIndex)
                val data = it.getString(dataIndex)  // This could be a Skype ID, username, etc.
                val contactId = it.getString(contactIdIndex)
                val mimeContact = mapOf(
                    "name" to name,
                    "data" to data,
                    "contact_id" to contactId
                )
                mimeContacts.add(mimeContact)
//                Helpers.printLog("mimeContact: ${mimeContact["data"]}")
            }
        }
//        Helpers.printLog("getMimeContacts $mimeContacts $mimeContacts")
        return mimeContacts
    }


    private fun getAvailableMimeTypes(context: Context): List<String> {
        val mimeTypes = mutableListOf<String>()
        val cursor: Cursor? = context.contentResolver.query(
            ContactsContract.Data.CONTENT_URI,
            arrayOf(ContactsContract.Data.MIMETYPE),
            null,
            null,
            ContactsContract.Data.MIMETYPE
        )

        cursor?.use {
            val mimeTypeIndex = it.getColumnIndex(ContactsContract.Data.MIMETYPE)
            while (it.moveToNext()) {
                val mimeType = it.getString(mimeTypeIndex)
                if (!mimeTypes.contains(mimeType)) {
                    mimeTypes.add(mimeType)
                }
            }
        }
//        Helpers.printLog("Available Mime Types $mimeTypes")
        return mimeTypes
    }

}