package vn.kalapa.behaviorsdk.models

import android.app.Activity
import android.widget.FrameLayout
import vn.kalapa.houseads.KalapaBannerAd
import vn.kalapa.houseads.listeners.KalapaAdListener

class KLPBehaviorBannerAd(frameLayout: FrameLayout, adUnitID: String, adListener: KLPBehaviorAdListener? = null) {
    private val klpBannerAd = KalapaBannerAd(frameLayout, adUnitID, object : KalapaAdListener {
        override fun onAdLoaded(adId: String) {
            adListener?.onAdLoaded(adId)
        }

        override fun onAdClosed(adId: String) {
            adListener?.onAdClosed(adId)

        }

        override fun onAdImpression(adId: String) {
            adListener?.onAdImpression(adId)

        }

        override fun onAdFailedToLoad(adId: String, exception: Exception) {
            adListener?.onAdFailedToLoad(adId, exception)

        }

        override fun onAdClicked(adId: String) {
            adListener?.onAdClicked(adId)

        }

        override fun onAdOpened(adId: String) {
            adListener?.onAdOpened(adId)
        }

    })

    fun stopAd() {
        klpBannerAd.stopAd()
    }

    fun setAdaptiveAdSizeWidth(width: Int) {
        klpBannerAd.setAdaptiveAdSizeWidth(width)
    }

    fun loadAd() {
        klpBannerAd.loadAd()
    }

    fun registerActivityLifecycleCallbacks(activity: Activity) {
        klpBannerAd.registerActivityLifecycleCallbacks(activity)
    }
}