package vn.kalapa.behaviorsdk.behavioral

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.os.Bundle

class PermissionProxyActivity : Activity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val permission = intent.getStringArrayExtra(EXTRA_PERMISSIONS)
    }

    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<out String>, grantResults: IntArray) {
        if (requestCode == REQUEST_PERMISSION) {
            val resultIntent = Intent(ACTION_PERMISSION_RESULT).apply {
                putExtra(EXTRA_GRANT_RESULTS, grantResults)
            }
            resultIntent.setPackage(this@PermissionProxyActivity.applicationContext.packageName)
            sendBroadcast(resultIntent) // Send the result to the Service
        }
        finish() // Close the invisible activity
    }

    companion object {
        const val REQUEST_PERMISSION = 100
        const val EXTRA_PERMISSIONS = "extra_permissions"
        const val EXTRA_GRANT_RESULTS = "extra_grant_results"
        const val ACTION_PERMISSION_RESULT = "vn.kalapa.behavior.PERMISSION_RESULT"

        fun start(activity: Context, permissions: Array<String>) {
            val intent = Intent(activity, PermissionProxyActivity::class.java)
            intent.putExtra(EXTRA_PERMISSIONS, permissions)
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK) // Ensure it works from a non-activity context
            activity.startActivity(intent)
        }
    }
}