//package vn.kalapa.behaviorsdk.managers
//
//import android.content.ComponentName
//import android.content.ContentProvider
//import android.content.ContentValues
//import android.content.Context
//import android.content.SharedPreferences
//import android.content.UriMatcher
//import android.database.Cursor
//import android.database.MatrixCursor
//import android.net.Uri
//import android.util.Log
//import java.util.UUID
//
//object KalapaUUIDHelper {
//    private const val PREFS_NAME = "local_uuid_cache"
//    private const val UUID_KEY = "cached_uuid"
//
//    fun getSharedUuid(context: Context): String {
//        val localUuid = getLocalUuid(context)
//        val providerUuid = getUuidFromProvider(context)
//
//        return if (providerUuid != null) {
//            // Provider has a UUID; keep local in sync
//            if (localUuid != providerUuid) {
//                setLocalUuid(context, providerUuid)
//            }
//            providerUuid
//        } else {
//            // No UUID in provider: use local or generate new, then store
//            val uuidToUse = localUuid ?: generateAndStoreUuid(context)
//            setUuidInProvider(context, uuidToUse)
//            uuidToUse
//        }
//    }
//
//    private fun getUuidFromProvider(context: Context): String? {
//        context.contentResolver.query(KalapaUUIDProvider.contentUri(context), arrayOf("uuid"), null, null, null)?.use { cursor ->
//            if (cursor.moveToFirst()) {
//                return cursor.getString(cursor.getColumnIndexOrThrow("uuid"))
//            }
//        }
//        return null
//    }
//
//    fun setUuidInProvider(context: Context, uuid: String) {
//        val values = ContentValues().apply {
//            put("uuid", uuid)
//        }
//        context.contentResolver.insert(KalapaUUIDProvider.contentUri(context), values)
//        setLocalUuid(context, uuid)
//    }
//
//    private fun getLocalUuid(context: Context): String? {
//        val prefs = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
//        return prefs.getString(UUID_KEY, null)
//    }
//
//    private fun setLocalUuid(context: Context, uuid: String) {
//        context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
//            .edit().putString(UUID_KEY, uuid).apply()
//    }
//
//    private fun generateAndStoreUuid(context: Context): String {
//        val newUuid = UUID.randomUUID().toString()
//        setLocalUuid(context, newUuid)
//        return newUuid
//    }
//
//}
//
//class KalapaUUIDProvider : ContentProvider() {
//
//    companion object {
//        private fun getCompName(context: Context): ComponentName {
//            return ComponentName(
//                context.packageName,
//                KalapaUUIDProvider::class.java.name
//            )
//        }
//
//        private fun authorityFromManifest(context: Context): String {
//            val info = context.packageManager.getProviderInfo(getCompName(context), 0)
//            return info.authority
//        }
//
//        private fun initialize(context: Context) {
//            AUTHORITY = authorityFromManifest(context)
//            CONTENT_URI = contentUri(context)
//            uriMatcher = UriMatcher(UriMatcher.NO_MATCH).apply {
//                addURI(AUTHORITY, UUID_PATH, CODE_UUID)
//            }
//        }
//
//        fun contentUri(context: Context): Uri {
//            val info = context.packageManager
//                .getProviderInfo(getCompName(context), /*flags=*/0)
//            // 3) Build the URI
//            return Uri.parse("content://${info.authority}/uuid")
//        }
//
//        private fun isInitialized(): Boolean {
//            return this::AUTHORITY.isInitialized && this::CONTENT_URI.isInitialized && this::uriMatcher.isInitialized
//        }
//
//        private const val TAG = "KalapaUUIDProvider"
//
//        //        private const val AUTHORITY = "vn.kalapa.behaviorsdk.uuidprovider" // Must match manifest
//        private lateinit var AUTHORITY: String
//        private const val UUID_PATH = "uuid"
//        private lateinit var CONTENT_URI: Uri
//
//        // URI matcher codes
//        private const val CODE_UUID = 1
//        private lateinit var uriMatcher: UriMatcher
//    }
//
//    private lateinit var sharedPreferences: SharedPreferences
//    private val PREFS_NAME = "shared_uuid_prefs"
//    private val UUID_KEY = "sdk_uuid"
//
//    override fun onCreate(): Boolean {
//        Log.d(TAG, "onCreate() called")
//        if (!isInitialized()) initialize(context!!)
//        sharedPreferences = context!!.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
//        return true
//    }
//
//    override fun query(
//        uri: Uri, projection: Array<String>?, selection: String?,
//        selectionArgs: Array<String>?, sortOrder: String?
//    ): Cursor? {
//        Log.d(TAG, "query() called with uri: $uri")
//        return when (uriMatcher.match(uri)) {
//            CODE_UUID -> {
//                val cursor = MatrixCursor(arrayOf("uuid")) // Define the column names
//                val uuid = sharedPreferences.getString(UUID_KEY, null)
//                uuid?.let { cursor.addRow(arrayOf(it)) } // Add a row if UUID exists
//                cursor.apply {
//                    setNotificationUri(context?.contentResolver, uri) // For observers
//                }
//            }
//
//            else -> {
//                Log.w(TAG, "Unknown URI: $uri")
//                null
//            }
//        }
//    }
//
//    override fun getType(uri: Uri): String? {
//        return when (uriMatcher.match(uri)) {
//            CODE_UUID -> "vnd.android.cursor.item/$AUTHORITY.$UUID_PATH"
//            else -> null
//        }
//    }
//
//    override fun insert(uri: Uri, values: ContentValues?): Uri? {
//        Log.d(TAG, "insert() called with uri: $uri, values: $values")
//        return when (uriMatcher.match(uri)) {
//            CODE_UUID -> {
//                val uuid = values?.getAsString("uuid")
//                if (uuid != null) {
//                    sharedPreferences.edit().putString(UUID_KEY, uuid).apply()
//                    context?.contentResolver?.notifyChange(uri, null) // Notify observers
//                    uri // Return the URI to indicate success
//                } else {
//                    Log.w(TAG, "Missing 'uuid' value in ContentValues")
//                    null
//                }
//            }
//
//            else -> {
//                Log.w(TAG, "Invalid URI for insert: $uri")
//                null
//            }
//        }
//    }
//
//    override fun delete(
//        uri: Uri, selection: String?, selectionArgs: Array<String>?
//    ): Int {
//        // Not implemented in this example, as we don't support deleting the UUID
//        Log.w(TAG, "delete() is not supported")
//        return 0
//    }
//
//    override fun update(
//        uri: Uri, values: ContentValues?, selection: String?,
//        selectionArgs: Array<String>?
//    ): Int {
//        // Not implemented in this example, as we don't support updating the UUID
//        Log.w(TAG, "update() is not supported")
//        return 0
//    }
//}
//
