package vn.kalapa.behaviorsdk.components

import android.content.Context


interface IKLPModule {
    //    var data: Map<String, Any>
    val key: String
    fun getRequirePermission(): Array<String>
    fun getPermissionAndNeededInfo(applicationContext: Context, completion: () -> Map<String, Any>): Map<String, Any>
    suspend fun setupCollectors(applicationContext: Context): Map<String, Any>
}

abstract class IKLPApplicationModule : IKLPModule {
    protected val APP_PACKAGES = mapOf(
        "com.discord" to "discord",
        "com.google.android.apps.tachyon" to "gmeet",
        "vn.com.vng.zalopay" to "zalopay",
        "com.instagram.android" to "instagram",
        "com.mbmobile" to "mbbank",
        "com.vnid" to "vneid",
        "com.google.android.apps.translate" to "googletranslate",
        "com.linkedin.android" to "linkedin",
        "com.binance.dev" to "bnc",
        "com.zing.zalo" to "zalo",
        "com.fplay.activity" to "fptplay",
        "org.telegram.messenger" to "telegram",
        "com.booking" to "booking",
        "xyz.be.cake" to "cake-vn",
        "com.zhiliaoapp.musically" to "tiktok",
        "com.instagram.barcelona" to "barcelona",
        "com.microsoft.office.powerpoint" to "powerpoint",
        "com.bplus.vtpay" to "viettelmoney",
        "com.microsoft.office.officehubrow" to "officemobile",
        "com.mservice.momotransfer" to "momo",
        "com.twitter.android" to "twitter",
        "com.vietinbank.ipay" to "vietinbankipay",
        "com.google.android.gm" to "googlegmail",
        "com.grabtaxi.passenger" to "grab",
        "com.whatsapp" to "whatsapp",
        "com.spotify.music" to "spotify",
        "xyz.be.customer" to "be",
        "com.vnpay.vpbankonline" to "vpbankneo",
        "com.openai.chatgpt" to "com-openai-chat",
        "us.zoom.videomeetings" to "zoomus",
        "com.agoda.mobile.consumer" to "agoda",
        "com.facebook.orca" to "fb-messenger",
        "com.facebook.katana" to "fb",
        "com.android.chrome" to "googlechrome",
        "com.google.android.apps.maps" to "comgooglemaps",
        "com.google.android.apps.docs" to "googledrive",
        "com.google.android.apps.dynamite" to "com-google-chat",
        "com.google.android.apps.docs.editors.sheets" to "googlesheets",
        "com.microsoft.teams" to "msteams",
        "com.skype.raider" to "skype",
        "vn.com.techcombank.bb.app" to "tcb",
        "com.netflix.mediaclient" to "nflx",
        "com.microsoft.office.outlook" to "ms-outlook",
        "com.snapchat.android" to "snapchat",
        "com.google.android.apps.docs.editors.docs" to "googledocs",
        "com.google.android.apps.youtube.music" to "youtubemusic",
        "com.google.android.youtube" to "youtube",
        "vn.shb.mbanking" to "shbmobile",
        "com.vnpay.bidv" to "bidvsmartbanking",
        "com.microsoft.office.excel" to "excel",
        "com.shopee.vn" to "shopee",
        "vn.tiki.app.tikiandroid" to "tiki",
        "com.lazada.android" to "lazada",
        "com.sendo" to "sendo",
        "com.vingroup.VinIDMerchantApp" to "vinid",
        "com.bachhoaxanh" to "bachhoaxanh",
        "com.chotot.vn" to "chotot",
        "vnpay.smartacccount" to "vnpay",
        "com.bigc.appbigc" to "bigc",
        // BET, GAMBLING
        "com.appasc.asc_user" to "fb68",
        "com.i5h1dy.brm9co.ohsi7u" to "68gamebai",
        "com.F1M3LIVE.soexample" to "fun88",
        "com.fb88fiber.fb88" to "fb88",
        "go88.naprut.xanhchin.uytin" to "go88",
        "com.ilgjrlijgi.jglrjliieirj" to "qh88",
        "com.ta28.club" to "ta28",
        "game.win79.nextgen" to "win79",
        "game.com.go88.tong5.n2025" to "b52",
        "com.kubet.casino" to "kubet",
        "hit.gamebai.uytin" to "hitclub",
        "com.game.x" to "789club",
        "com.nohuthantai.bonus" to "nohuthantai",
        "com.teamdev.discshock" to "xocdiataixiu",
        "com.sun.win" to "sunwin",
        "com.bommm.rongvangggg.rikkkk" to "rikvip",
        "com.vndc" to "onus_binance",
        "com.gem.win" to "gemwin",
        "iwin.gamebai.naprut.uytin" to "iwin",
        "com.zempotmalay.winjoy_c" to "winjoy_online",
        "com.bicirwmejtgxygku" to "md5_taixiu",
        "com.angeltalk" to "angeltalk"
    )

    protected fun convertMillisecondsToMinutes(x: Long): Int {
        return when (x) {
            0L -> 0
            in 1 until 60000 -> 1
            else -> (x / 60000).toInt()
        }
    }
}