package vn.kalapa.behaviorsdk.managers

import android.app.Fragment
import android.content.pm.PackageManager
import android.os.Build


class PermissionRequestFragment : Fragment() {
    private var permissionHandler: KLPPermissionHandler? = null

    fun requestPermissions(permissions: Array<String>, handler: KLPPermissionHandler) {
        this.permissionHandler = handler
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            requestPermissions(permissions, REQUEST_PERMISSION)
    }

    @Deprecated("Deprecated in Java")
    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<out String>, grantResults: IntArray) {
        if (requestCode == REQUEST_PERMISSION) {
            if (grantResults.isNotEmpty() && grantResults.all { it == PackageManager.PERMISSION_GRANTED }) {
                permissionHandler?.onPermissionGranted()
            } else {
                permissionHandler?.onPermissionDenied()
            }
        }
    }

    companion object {
        private const val REQUEST_PERMISSION = 100

        fun newInstance(): PermissionRequestFragment {
            return PermissionRequestFragment()
        }
    }
}