package vn.kalapa.behaviorsdk.behavioral

import android.R
import android.annotation.SuppressLint
import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.Service
import android.content.Intent
import android.os.Build
import android.os.IBinder
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.EditText
import android.widget.SeekBar
import androidx.core.app.NotificationCompat
import vn.kalapa.behaviorsdk.behavioral.viewhandler.ButtonViewHandler
import vn.kalapa.behaviorsdk.behavioral.viewhandler.DefaultViewHandler
import vn.kalapa.behaviorsdk.behavioral.viewhandler.IViewHandler
import vn.kalapa.behaviorsdk.behavioral.viewhandler.EditTextViewHandler
import vn.kalapa.behaviorsdk.behavioral.viewhandler.SeekbarViewHandler
import vn.kalapa.behaviorsdk.components.KLPBehavioralModule
import vn.kalapa.behaviorsdk.utils.Common
import vn.kalapa.behaviorsdk.utils.Helpers

class KLPGlobalEventService : Service() {
    private val TAG = "KLPGlobalEventService"
    private val CHANNEL_ID = "KLPGlobalEventService"
    private var isTrackingStarted = false
    override fun onCreate() {
        super.onCreate()
//        createNotificationChannel() // No foreground stuff needed here anymore
//        startServiceNotification() // No foreground stuff needed here anymore
    }

    private fun createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val channelNotification = NotificationChannel(
                CHANNEL_ID,
                TAG,
                NotificationManager.IMPORTANCE_MIN
            ).apply {
                description = "Monitoring user interactions..."
            }
            val manager = getSystemService(NOTIFICATION_SERVICE) as NotificationManager
            manager.createNotificationChannel(channelNotification)
        }
    }

    private fun startServiceNotification() {
        val notification: Notification = NotificationCompat.Builder(this, CHANNEL_ID)
            .setContentTitle("Interaction Monitoring Service")
            .setContentText("Monitoring user interactions...")
            .setSmallIcon(vn.kalapa.behaviorsdk.R.drawable.klp_logo)
            .setPriority(NotificationCompat.PRIORITY_MIN)
            .setCategory(Notification.CATEGORY_SERVICE)
            .setOngoing(true)
            .build()
        startForeground(1, notification)
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        if (!isTrackingStarted && KLPBehavioralModule.isTrackingActivityInitialized()) {
            isTrackingStarted = true
            val trackingActivity = KLPBehavioralModule.trackingActivity
            val rootView = trackingActivity.window.decorView.findViewById<View>(R.id.content)
            rootView?.let {
                Helpers.printLog(TAG, "onStartCommand rootView ")
                Helpers.printLog(TAG, "onStartCommand rootView ${Common.getKLPFormatResourcesName(it)}")
                setClickListenersRecursively(it, Common.getKLPFormatResourcesName(it))
            }
        } else {
            Helpers.printLog(TAG, "Tracking already started or activity not initialized")
        }
        return START_STICKY
    }


    override fun onBind(intent: Intent?): IBinder? {
        Helpers.printLog(TAG, "onBind")
        return null
    }

    @SuppressLint("ClickableViewAccessibility")
    private fun setClickListenersRecursively(view: View, path: String) {
        // If the view is clickable, set an OnClickListener
        if (view.javaClass.simpleName != "FlutterSurfaceView"){
            Helpers.printLog("setClickListenersRecursively - view: ${view.javaClass.simpleName}")
            ViewHandlerFactory.createHandler(view, path)?.handle()
        }else
            Helpers.printLog("setClickListenersRecursively - ignore view: ${view.javaClass.simpleName}")
        if (view is ViewGroup) {
            for (i in 0 until view.childCount) {
                val child = view.getChildAt(i)
                val resourceName = Common.getKLPFormatResourcesName(child)
                val childPath = "$path;$resourceName"
                setClickListenersRecursively(child, childPath)
            }
        }
    }
}

object ViewHandlerFactory {
    fun createHandler(view: View, path: String): IViewHandler? {
        return when (view) {
            is EditText -> EditTextViewHandler(view, path)
            is SeekBar -> SeekbarViewHandler(view, path)
//            is Slider -> SlidableViewHandler(view, path)
            is Button -> ButtonViewHandler(view, path)
            else -> DefaultViewHandler(view, path)
        }
    }
}