package vn.kalapa.behaviorsdk.behavioral.viewhandler

import android.annotation.SuppressLint
import android.os.Build
import android.view.MotionEvent
import android.view.SurfaceView
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import vn.kalapa.behaviorsdk.components.KLPBehavioralModule
import vn.kalapa.behaviorsdk.models.KLPBehaviorObject
import vn.kalapa.behaviorsdk.utils.Helpers
import java.lang.reflect.Field
import kotlin.math.pow
import kotlin.math.sqrt

open class DefaultViewHandler(private val view: View, private val path: String) : IViewHandler {
    val TAG = "IViewHandler ${this.javaClass.simpleName}"
    private var start: Long = System.currentTimeMillis()
    private val MIN_SWIPE_DISTANCE = 20 // Pixels
    private var movePosition: KLPBehaviorObject.KLPBehaviorPosition? = null
    override fun handleClick(): Boolean {
        return false
    }

    override fun handleTouch(event: MotionEvent): Boolean {
        return false
    }

    @SuppressLint("ClickableViewAccessibility")
    override fun handle() {
        if (view !is ViewGroup || view.childCount == 1) {
            view.setOnTouchListener { _, event ->
                val position = KLPBehaviorObject.KLPBehaviorPosition(event.x.toInt(), event.y.toInt())
                val viewName = view.javaClass.simpleName
                val viewId = view.id
                val isViewGroup = view is ViewGroup

                fun logAction(action: String) {
                    val childInfo = if (isViewGroup) " and has ${(view as ViewGroup).childCount}" else "-View"
                    Helpers.printLog("on MotionEvent.$action View $viewName $viewId$childInfo")
                }

                when (event.action) {
                    MotionEvent.ACTION_DOWN -> {
                        logAction("ACTION_DOWN")
                        start = System.currentTimeMillis()
                        movePosition = null
                        return@setOnTouchListener !(view is SurfaceView || (isViewGroup && (view as ViewGroup).childCount == 1))
                    }

                    MotionEvent.ACTION_MOVE -> {
                        if (movePosition == null) movePosition = position
                        false
                    }

                    MotionEvent.ACTION_UP -> {
                        logAction("ACTION_UP")
                        val distance = movePosition?.let {
                            calculateDistance(it.x, it.y, position.x, position.y)
                        } ?: 0
                        if (distance < MIN_SWIPE_DISTANCE) {
                            view.performClick()
                            KLPBehavioralModule.addBehavior(KLPBehaviorObject.KLPBehaviorClick(path, position))
                        } else {
                            movePosition?.let { movePos ->
                                KLPBehavioralModule.addBehavior(
                                    KLPBehaviorObject.KLPBehaviorPointer(
                                        path,
                                        System.currentTimeMillis() - start,
                                        distance,
                                        arrayOf(movePos, position)
                                    )
                                )
                            }
                        }
                        movePosition = null
                        false
                    }

                    else -> {
                        logAction(getActionName(event.action))
                        false
                    }
                }
            }
        }
    }


    private fun getActionName(action: Int): String {
        return when (action) {
            MotionEvent.ACTION_BUTTON_PRESS -> "BUTTON_PRESS"
            MotionEvent.ACTION_BUTTON_RELEASE -> "BUTTON_RELEASE"
            MotionEvent.ACTION_CANCEL -> "CANCEL"
            MotionEvent.ACTION_DOWN -> "DOWN"
            MotionEvent.ACTION_HOVER_ENTER -> "HOVER_ENTER"
            MotionEvent.ACTION_HOVER_EXIT -> "HOVER_EXIT"
            MotionEvent.ACTION_HOVER_MOVE -> "HOVER_MOVE"
            MotionEvent.ACTION_MASK -> "MASK"
            MotionEvent.ACTION_MOVE -> "MOVE"
            MotionEvent.ACTION_OUTSIDE -> "OUTSIDE"
            MotionEvent.ACTION_POINTER_1_DOWN -> "POINTER_1_DOWN"
            MotionEvent.ACTION_POINTER_1_UP -> "POINTER_1_UP"
            MotionEvent.ACTION_POINTER_2_DOWN -> "POINTER_2_DOWN"
            MotionEvent.ACTION_POINTER_2_UP -> "POINTER_2_UP"
            MotionEvent.ACTION_POINTER_3_DOWN -> "POINTER_3_DOWN"
            MotionEvent.ACTION_POINTER_3_UP -> "POINTER_3_UP"
            MotionEvent.ACTION_POINTER_DOWN -> "POINTER_DOWN"
            MotionEvent.ACTION_POINTER_ID_MASK -> "POINTER_ID_MASK"
            MotionEvent.ACTION_POINTER_ID_SHIFT -> "POINTER_ID_SHIFT"
            MotionEvent.ACTION_POINTER_INDEX_MASK -> "POINTER_INDEX_MASK"
            MotionEvent.ACTION_POINTER_INDEX_SHIFT -> "POINTER_INDEX_SHIFT"
            MotionEvent.ACTION_POINTER_UP -> "POINTER_UP"
            MotionEvent.ACTION_SCROLL -> "SCROLL"
            MotionEvent.ACTION_UP -> "UP"
            else -> "UNKNOWN_ACTION"
        }
    }

    private fun calculateDistance(x1: Float, y1: Float, x2: Float, y2: Float): Int {
        return (sqrt((x2 - x1).pow(2) + (y2 - y1).pow(2))).toInt()
    }

    private fun calculateDistance(x1: Int, y1: Int, x2: Int, y2: Int): Int {
        return (sqrt((x2 - x1).toFloat().pow(2) + (y2 - y1).toFloat().pow(2))).toInt()
    }

}
