package vn.kalapa.behaviorsdk.behavioral.viewhandler

import android.text.Editable
import android.text.TextWatcher
import android.view.KeyEvent.ACTION_DOWN
import android.view.KeyEvent.KEYCODE_DEL
import android.view.KeyEvent.KEYCODE_PASTE
import android.view.KeyEvent.keyCodeToString
import android.widget.EditText
import vn.kalapa.behaviorsdk.components.KLPBehavioralModule
import vn.kalapa.behaviorsdk.models.KLPBehaviorObject
import vn.kalapa.behaviorsdk.utils.Helpers

class EditTextViewHandler(private val v: EditText, private val path: String) : DefaultViewHandler(v, path) {
    override fun handle() {
        v.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
                // Optionally handle before text changed
            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                if (before == 1 && count == 0) {
                    val behavior = KLPBehaviorObject.KLPBehaviorKeyboard(
                        path,
                        "Delete",
                        KLPBehaviorObject.KLPBehaviorPosition(v.x.toInt(), v.y.toInt())
                    )
                    KLPBehavioralModule.addBehavior(behavior)
                } else if (count > 1) {
                    // Paste or auto fill
                    val behavior = KLPBehaviorObject.KLPBehaviorAutofill(
                        path,
                        s.toString().substring(s.toString().length - count),
                        KLPBehaviorObject.KLPBehaviorPosition(v.x.toInt(), v.y.toInt())
                    )
                    KLPBehavioralModule.addBehavior(behavior)
                }
            }

            override fun afterTextChanged(s: Editable?) {
                // Optionally handle after text changed
//                Helpers.printLog("afterTextChanged $s")
            }
        })

        // Handle the "Done" action or any other IME action
        v.setOnEditorActionListener { _, actionId, _ ->
            if (actionId == android.view.inputmethod.EditorInfo.IME_ACTION_DONE) {
                val behavior = KLPBehaviorObject.KLPBehaviorKeyboard(
                    path, "Done",
                    KLPBehaviorObject.KLPBehaviorPosition(v.x.toInt(), v.y.toInt())
                )
                KLPBehavioralModule.addBehavior(behavior)
            }
            false // Allow the default behavior to occur
        }
        v.setOnKeyListener { _, _, event ->
            if (event.action == ACTION_DOWN) {
                when (event.keyCode) {
                    KEYCODE_DEL -> {
                        if (v.text.toString().isNotEmpty())
                            KLPBehavioralModule.addBehavior(
                                KLPBehaviorObject.KLPBehaviorKeyboard(
                                    path,
                                    "Delete",
                                    KLPBehaviorObject.KLPBehaviorPosition(v.x.toInt(), v.y.toInt())
                                )
                            )
                    }

                    KEYCODE_PASTE -> {
                        KLPBehavioralModule.addBehavior(
                            KLPBehaviorObject.KLPBehaviorKeyboard(
                                path,
                                event.displayLabel.toString(),
                                KLPBehaviorObject.KLPBehaviorPosition(v.x.toInt(), v.y.toInt())
                            )
                        )
                    }

                    else -> {
                        KLPBehavioralModule.addBehavior(
                            KLPBehaviorObject.KLPBehaviorKeyboard(
                                path,
                                event.displayLabel.toString(),
                                KLPBehaviorObject.KLPBehaviorPosition(v.x.toInt(), v.y.toInt())
                            )
                        )
                    }
                }
            }
            false
        }
    }
}