package vn.kalapa.behaviorsdk.utils

import android.content.Context

fun isPermissionDeclared(context: Context, permission: String): Boolean {
    val packageInfo = context.packageManager.getPackageInfo(
        context.packageName,
        android.content.pm.PackageManager.GET_PERMISSIONS
    )
    val declaredPermissions = packageInfo.requestedPermissions ?: return false
    return declaredPermissions.contains(permission)
}