package vn.kalapa.behaviorsdk.managers

import android.app.Activity
import android.content.pm.PackageManager
import android.os.Handler
import android.os.Looper
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import vn.kalapa.behaviorsdk.utils.Common.Companion.getArrayOfPermission


interface KLPPermissionHandler {
    fun onPermissionGranted()
    fun onPermissionDenied()
}

class PermissionFragment(private val activity: Activity) : Fragment() {
    private var permissionResultCallback: ((Boolean) -> Unit)? = null

    companion object {
        private const val REQUEST_CODE = 188

        fun newInstance(activity: Activity): PermissionFragment {
            return PermissionFragment(activity)
        }
    }

    private var permissionCallback: KLPPermissionHandler? = null

    fun requestPermission(requestPermission: Array<String>, callback: (Boolean) -> Unit) {
        var isAllGranted = true
        permissionResultCallback = callback
        for (permission in getArrayOfPermission()) {
            if (ContextCompat.checkSelfPermission(activity, permission) != PackageManager.PERMISSION_GRANTED) {
//                requestPermissions(if (requestPermission.isNotEmpty()) requestPermission else getArrayOfPermission(), REQUEST_CODE)
                requestPermissions(requestPermission, REQUEST_CODE)
                isAllGranted = false
                break
            }
        }
        if (isAllGranted) // Khi ta
            callback(true)

    }

    @Deprecated("Deprecated in Java")
    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<out String>, grantResults: IntArray) {
        if (requestCode == REQUEST_CODE) {
            if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                permissionResultCallback?.invoke(true)
            } else {
                permissionResultCallback?.invoke(false)
            }
        }
    }

    override fun onDetach() {
        super.onDetach()
        permissionCallback = null
    }
}

class PermissionRequester(private val activity: Activity,private val fragmentManager: FragmentManager) {

    private var permissionFragment: PermissionFragment? = null

    init {
        // Try to find the fragment if it already exists
        permissionFragment = fragmentManager.findFragmentByTag("PermissionFragment") as? PermissionFragment
        if (permissionFragment == null) {
            permissionFragment = PermissionFragment.newInstance(activity)
            fragmentManager
                .beginTransaction()
                .add(permissionFragment!!, "PermissionFragment")
                .commit()
        }
    }

    // Call this method to request permission
    fun requestPermission(permission: Array<String>, callback: (Boolean) -> Unit) {
        fun tryRequest(attempt: Int = 1) {
            if (permissionFragment?.isAdded == true && permissionFragment?.context != null) {
                // Safe to call immediately
                permissionFragment?.requestPermission(permission, callback)
            } else if (attempt <= 3) {
                // Retry after 100ms
                Handler(Looper.getMainLooper()).postDelayed({
                    tryRequest(attempt + 1)
                }, 100)
            } else {
                // Failed after 3 attempts
                callback(false)
            }
        }
        tryRequest()
    }
}