package vn.kalapa.behaviorsdk.managers

import android.content.Context
import com.google.android.gms.ads.identifier.AdvertisingIdClient
import com.google.android.gms.common.ConnectionResult
import com.google.android.gms.common.GoogleApiAvailability
import com.google.android.gms.common.GooglePlayServicesNotAvailableException
import com.google.android.gms.common.GooglePlayServicesRepairableException
import vn.kalapa.behaviorsdk.utils.Helpers
import java.io.IOException
import java.lang.NoClassDefFoundError

//
//object UUIDManager {
//    fun getOrSetUUID(context: Context): String {
//        return KalapaUUIDHelper.getSharedUuid(context)
//    }
//}

object GooglePlayServicesHelper {
    fun getGADeviceId(context: Context): String? {
        try {
            if (isGooglePlayServicesAvailable(context)) {
                try {
                    val aaid = getAAID(context)
                    //"00000000-0000-0000-0000-000000000000"
                    // GooglePlayServicesHelper.getAAID(context)
                    if (aaid != null) {
                        Helpers.printLog("GooglePlay Service is Okay. aaid: $aaid")
                        return aaid
                    } else Helpers.printLog("GooglePlay Service is Okay but AAID return null")
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            } else
                Helpers.printLog("GooglePlay Service is missing or not available")
        } catch (e: NoClassDefFoundError) {
            Helpers.printLog("GooglePlay Service is not implemented")
        }
        return null
    }

    private fun isGooglePlayServicesAvailable(context: Context): Boolean {
        try {
            val googleApiAvailability = GoogleApiAvailability.getInstance()
            val resultCode = googleApiAvailability.isGooglePlayServicesAvailable(context)
            return resultCode == ConnectionResult.SUCCESS
        } catch (e: NoClassDefFoundError) {
            return false
        }
    }

    private fun getAAID(context: Context): String? {
        return try {
            val adInfo: AdvertisingIdClient.Info = AdvertisingIdClient.getAdvertisingIdInfo(context)
            adInfo.id // Returns the Advertising ID
        } catch (e: GooglePlayServicesNotAvailableException) {
            // Google Play Services is not available on the device.
            // Handle this case appropriately, e.g., log the error or return null.
            println("Google Play Services not available: ${e.message}")
            null
        } catch (e: GooglePlayServicesRepairableException) {
            // Google Play Services needs to be updated.
            // Handle this case appropriately, e.g., prompt the user to update.
            println("Google Play Services needs repair: ${e.message}")
            null
        } catch (e: IOException) {
            // Network or I/O error occurred.
            // Handle this case appropriately, e.g., retry or return null.
            println("IO error occurred: ${e.message}")
            null
        } catch (e: IllegalStateException) {
            // The call is not made on the main thread.
            println("Illegal State Exception: ${e.message}")
            null
        } catch (e: NoClassDefFoundError) {
            // The call is not made on the main thread.
            println("NoClassDefFoundError Exception: ${e.message}")
            null
        } catch (e: Exception) {
            // General exception handling.
            println("An unexpected error occurred: ${e.message}")
            null
        }
    }
}
