/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import java.io.IOException;

public class ASN1Boolean
extends ASN1Primitive {
    private static final byte FALSE_VALUE = 0;
    private static final byte TRUE_VALUE = -1;
    public static final ASN1Boolean FALSE = new ASN1Boolean(0);
    public static final ASN1Boolean TRUE = new ASN1Boolean(-1);
    private final byte value;

    public static ASN1Boolean getInstance(Object object) {
        if (object != null && !(object instanceof ASN1Boolean)) {
            if (object instanceof byte[]) {
                try {
                    return (ASN1Boolean)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, a.a("failed to construct boolean from byte[]: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, a.a("illegal object in getInstance: ")));
        }
        return (ASN1Boolean)object;
    }

    public static ASN1Boolean getInstance(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(int n) {
        return n != 0 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof ASN1Boolean)) {
            return ASN1Boolean.fromOctetString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return ASN1Boolean.getInstance(aSN1Primitive);
    }

    private ASN1Boolean(byte by) {
        this.value = by;
    }

    public static ASN1Boolean fromOctetString(byte[] byArray) {
        if (byArray.length == 1) {
            byte by = byArray[0];
            if (by != -1) {
                if (by != 0) {
                    return new ASN1Boolean(by);
                }
                return FALSE;
            }
            return TRUE;
        }
        throw new IllegalArgumentException("BOOLEAN value should have 1 byte in it");
    }

    public boolean isTrue() {
        return this.value != 0;
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        return 3;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        byte by = this.value;
        aSN1OutputStream.writeEncoded(bl, 1, by);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Boolean)) {
            return false;
        }
        ASN1Boolean aSN1Boolean = aSN1Boolean2;
        ASN1Boolean aSN1Boolean2 = (ASN1Boolean)aSN1Primitive;
        return aSN1Boolean.isTrue() == aSN1Boolean2.isTrue();
    }

    @Override
    public int hashCode() {
        return this.isTrue() ? 1 : 0;
    }

    @Override
    public ASN1Primitive toDERObject() {
        return this.isTrue() ? TRUE : FALSE;
    }

    public String toString() {
        return this.isTrue() ? "TRUE" : "FALSE";
    }
}

