/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Exception;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1StreamParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERApplicationSpecificParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BEROctetStringParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequenceParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSetParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTaggedObjectParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTags;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERExternalParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLExternal;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DefiniteLengthInputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.IndefiniteLengthInputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.LazyEncodedSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1InputStream
extends FilterInputStream
implements BERTags {
    private final int limit;
    private final boolean lazyEvaluate;
    private final byte[][] tmpBuffers;

    public ASN1InputStream(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit(inputStream));
    }

    public ASN1InputStream(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream;
        ASN1InputStream aSN1InputStream = inputStream;
        InputStream inputStream = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        aSN1InputStream(inputStream, byArray.length);
    }

    public ASN1InputStream(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream;
        ASN1InputStream aSN1InputStream = inputStream;
        InputStream inputStream = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        aSN1InputStream(inputStream, byArray.length, bl);
    }

    public ASN1InputStream(InputStream inputStream, int n) {
        this(inputStream, n, false);
    }

    public ASN1InputStream(InputStream inputStream, boolean bl) {
        this(inputStream, StreamUtil.findLimit(inputStream), bl);
    }

    public ASN1InputStream(InputStream inputStream, int n, boolean bl) {
        ASN1InputStream aSN1InputStream = this;
        super(inputStream);
        this.limit = n;
        aSN1InputStream.lazyEvaluate = bl;
        aSN1InputStream.tmpBuffers = new byte[11][];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int readTagNumber(InputStream inputStream, int n) {
        if ((n &= 0x1F) != 31) return n;
        n = 0;
        int n2 = inputStream.read();
        if ((n2 & 0x7F) == 0) throw new IOException("corrupted stream - invalid high tag number found");
        while (n2 >= 0 && (n2 & 0x80) != 0) {
            n = (n | n2 & 0x7F) << 7;
            n2 = inputStream.read();
        }
        if (n2 < 0) throw new EOFException("EOF found inside tag value.");
        n |= n2 & 0x7F;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int readLength(InputStream inputStream, int n, boolean bl) {
        int n2 = inputStream.read();
        if (n2 < 0) throw new EOFException("EOF found when length expected");
        if (n2 == 128) {
            return -1;
        }
        if (n2 <= 127) return n2;
        if ((n2 &= 0x7F) > 4) throw new IOException(a.a("DER length more than 4 bytes: ", n2));
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            int n4 = inputStream.read();
            if (n4 < 0) throw new EOFException("EOF found reading length");
            n3 = (n3 << 8) + n4;
        }
        if (n3 < 0) throw new IOException("corrupted stream - negative length found");
        if (n3 < n) return n3;
        if (!bl) throw new IOException("corrupted stream - out of bounds length found: " + n3 + " >= " + n);
        return n3;
    }

    private static byte[] getBuffer(DefiniteLengthInputStream definiteLengthInputStream, byte[][] byArray) {
        int n = definiteLengthInputStream.getRemaining();
        if (n >= byArray.length) {
            return definiteLengthInputStream.toByteArray();
        }
        byte[] byArray2 = byArray[n];
        if (byArray2 == null) {
            byArray2 = new byte[n];
            byArray[n] = byArray2;
        }
        definiteLengthInputStream.readAllIntoByteArray(byArray2);
        return byArray2;
    }

    private static char[] getBMPCharBuffer(DefiniteLengthInputStream definiteLengthInputStream) {
        int n = definiteLengthInputStream.getRemaining();
        if ((n & 1) == 0) {
            int n2;
            int n3 = n / 2;
            char[] cArray = new char[n3];
            int n4 = 0;
            byte[] byArray = new byte[8];
            while (n >= 8) {
                if (Streams.readFully(definiteLengthInputStream, byArray, 0, 8) == 8) {
                    cArray[n4] = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
                    n2 = n4 + 1;
                    cArray[n2] = (char)(byArray[2] << 8 | byArray[3] & 0xFF);
                    n2 = n4 + 2;
                    cArray[n2] = (char)(byArray[4] << 8 | byArray[5] & 0xFF);
                    n2 = n4 + 3;
                    cArray[n2] = (char)(byArray[6] << 8 | byArray[7] & 0xFF);
                    n4 += 4;
                    n -= 8;
                    continue;
                }
                throw new EOFException("EOF encountered in middle of BMPString");
            }
            if (n > 0) {
                if (Streams.readFully(definiteLengthInputStream, byArray, 0, n) == n) {
                    n2 = 0;
                    while (true) {
                        int n5 = byArray[n2++] << 8;
                        int n6 = n2 + 1;
                        cArray[n4++] = (char)(n5 | byArray[n2] & 0xFF);
                        if (n6 < n) {
                            n2 = n6;
                            continue;
                        }
                        break;
                    }
                } else {
                    throw new EOFException("EOF encountered in middle of BMPString");
                }
            }
            if (definiteLengthInputStream.getRemaining() == 0 && n3 == n4) {
                return cArray;
            }
            throw new IllegalStateException();
        }
        throw new IOException("malformed BMPString encoding encountered");
    }

    /*
     * Exception decompiling
     */
    public static ASN1Primitive createPrimitiveDERObject(int var0, DefiniteLengthInputStream var1_1, byte[][] var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 8[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getLimit() {
        return this.limit;
    }

    public int readLength() {
        ASN1InputStream aSN1InputStream = this;
        return ASN1InputStream.readLength(aSN1InputStream, aSN1InputStream.limit, false);
    }

    public void readFully(byte[] byArray) {
        if (Streams.readFully(this, byArray) == byArray.length) {
            return;
        }
        throw new EOFException("EOF encountered in middle of object");
    }

    public ASN1Primitive buildObject(int n, int n2, int n3) {
        Object object;
        DefiniteLengthInputStream definiteLengthInputStream;
        boolean bl = (n & 0x20) != 0;
        DefiniteLengthInputStream definiteLengthInputStream2 = definiteLengthInputStream;
        ASN1InputStream aSN1InputStream = object;
        definiteLengthInputStream = new DefiniteLengthInputStream(aSN1InputStream, n3, aSN1InputStream.limit);
        if ((n & 0x40) != 0) {
            object = definiteLengthInputStream2.toByteArray();
            return new DLApplicationSpecific(bl, n2, (byte[])object);
        }
        if ((n & 0x80) != 0) {
            return new ASN1StreamParser(definiteLengthInputStream2).readTaggedObject(bl, n2);
        }
        if (bl) {
            if (n2 != 4) {
                if (n2 != 8) {
                    if (n2 != 16) {
                        if (n2 == 17) {
                            return DLFactory.createSet(((ASN1InputStream)object).readVector(definiteLengthInputStream2));
                        }
                        throw new IOException(f.a("unknown tag ", n2, " encountered"));
                    }
                    if (((ASN1InputStream)object).lazyEvaluate) {
                        return new LazyEncodedSequence(definiteLengthInputStream2.toByteArray());
                    }
                    return DLFactory.createSequence(((ASN1InputStream)object).readVector(definiteLengthInputStream2));
                }
                return new DLExternal(((ASN1InputStream)object).readVector(definiteLengthInputStream2));
            }
            object = ((ASN1InputStream)object).readVector(definiteLengthInputStream2);
            n = ((ASN1EncodableVector)object).size();
            ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[n];
            for (n3 = 0; n3 != n; ++n3) {
                ASN1Encodable aSN1Encodable = ((ASN1EncodableVector)object).get(n3);
                if (aSN1Encodable instanceof ASN1OctetString) {
                    aSN1OctetStringArray[n3] = (ASN1OctetString)aSN1Encodable;
                    continue;
                }
                throw new ASN1Exception(b.a.a("unknown object encountered in constructed OCTET STRING: ").append(aSN1Encodable.getClass()).toString());
            }
            return new BEROctetString(aSN1OctetStringArray);
        }
        return ASN1InputStream.createPrimitiveDERObject(n2, definiteLengthInputStream2, ((ASN1InputStream)object).tmpBuffers);
    }

    public ASN1EncodableVector readVector(DefiniteLengthInputStream object) {
        ASN1Primitive aSN1Primitive;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1InputStream aSN1InputStream;
        if (((DefiniteLengthInputStream)object).getRemaining() < 1) {
            return new ASN1EncodableVector(0);
        }
        ASN1InputStream aSN1InputStream2 = aSN1InputStream;
        aSN1InputStream = new ASN1InputStream((InputStream)object);
        object = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Primitive = aSN1InputStream2.readObject()) != null) {
            ((ASN1EncodableVector)object).add(aSN1Primitive);
        }
        return object;
    }

    public ASN1Primitive readObject() {
        int n = ((InputStream)this).read();
        if (n <= 0) {
            if (n != 0) {
                return null;
            }
            throw new IOException("unexpected end-of-contents marker");
        }
        int n2 = ASN1InputStream.readTagNumber(this, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = this.readLength();
        if (n3 < 0) {
            if (bl) {
                ASN1StreamParser aSN1StreamParser;
                IndefiniteLengthInputStream indefiniteLengthInputStream;
                IndefiniteLengthInputStream indefiniteLengthInputStream2 = indefiniteLengthInputStream;
                ASN1InputStream aSN1InputStream = this;
                indefiniteLengthInputStream = new IndefiniteLengthInputStream(aSN1InputStream, aSN1InputStream.limit);
                ASN1StreamParser aSN1StreamParser2 = aSN1StreamParser;
                aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream2, this.limit);
                if ((n & 0x40) != 0) {
                    return new BERApplicationSpecificParser(n2, aSN1StreamParser2).getLoadedObject();
                }
                if ((n & 0x80) != 0) {
                    return new BERTaggedObjectParser(true, n2, aSN1StreamParser2).getLoadedObject();
                }
                if (n2 != 4) {
                    if (n2 != 8) {
                        if (n2 != 16) {
                            if (n2 == 17) {
                                return new BERSetParser(aSN1StreamParser2).getLoadedObject();
                            }
                            throw new IOException("unknown BER object encountered");
                        }
                        return new BERSequenceParser(aSN1StreamParser2).getLoadedObject();
                    }
                    return new DERExternalParser(aSN1StreamParser2).getLoadedObject();
                }
                return new BEROctetStringParser(aSN1StreamParser2).getLoadedObject();
            }
            throw new IOException("indefinite-length primitive encoding encountered");
        }
        try {
            return this.buildObject(n, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }
}

