/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.OIDTokenizer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ASN1ObjectIdentifier
extends ASN1Primitive {
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static final ConcurrentMap<OidHandle, ASN1ObjectIdentifier> pool = new ConcurrentHashMap<OidHandle, ASN1ObjectIdentifier>();
    private final String identifier;
    private byte[] body;

    public static ASN1ObjectIdentifier getInstance(Object object) {
        if (object != null && !(object instanceof ASN1ObjectIdentifier)) {
            ASN1Primitive aSN1Primitive;
            if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1ObjectIdentifier) {
                return (ASN1ObjectIdentifier)aSN1Primitive;
            }
            if (object instanceof byte[]) {
                try {
                    return (ASN1ObjectIdentifier)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, a.a("failed to construct object identifier from byte[]: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, a.a("illegal object in getInstance: ")));
        }
        return (ASN1ObjectIdentifier)object;
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return ASN1ObjectIdentifier.getInstance(aSN1Primitive);
    }

    public ASN1ObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        long l = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int k = 0; k != byArray.length; ++k) {
            int n = byArray[k] & 0xFF;
            if (l <= 0xFFFFFFFFFFFF80L) {
                l += (long)(n & 0x7F);
                if ((n & 0x80) == 0) {
                    if (bl) {
                        if (l < 40L) {
                            stringBuffer2.append('0');
                        } else if (l < 80L) {
                            stringBuffer2.append('1');
                            l -= 40L;
                        } else {
                            stringBuffer2.append('2');
                            l -= 80L;
                        }
                        bl = false;
                    }
                    StringBuffer stringBuffer3 = stringBuffer2;
                    stringBuffer3.append('.');
                    stringBuffer3.append(l);
                    l = 0L;
                    continue;
                }
                l <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n & 0x7F));
            if ((n & 0x80) == 0) {
                if (bl) {
                    stringBuffer2.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl = false;
                }
                StringBuffer stringBuffer4 = stringBuffer2;
                stringBuffer4.append('.');
                stringBuffer4.append(bigInteger);
                Object var3_4 = null;
                long l2 = 0L;
                bigInteger = var3_4;
                l = l2;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.identifier = stringBuffer2.toString();
        this.body = Arrays.clone(byArray);
    }

    public ASN1ObjectIdentifier(String string) {
        if (string != null) {
            if (ASN1ObjectIdentifier.isValidIdentifier(string)) {
                this.identifier = string;
                return;
            }
            throw new IllegalArgumentException(g.a("string ", string, " not an OID"));
        }
        throw new NullPointerException("'identifier' cannot be null");
    }

    public ASN1ObjectIdentifier(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (ASN1ObjectIdentifier.isValidBranchID(string, 0)) {
            this.identifier = aSN1ObjectIdentifier.getId() + "." + string;
            return;
        }
        throw new IllegalArgumentException(g.a("string ", string, " not a valid OID branch"));
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, long l) {
        byte[] byArray = new byte[9];
        Object object = byArray;
        int n = 8;
        byArray[8] = (byte)((int)l & 0x7F);
        while (l >= 128L) {
            object[n += -1] = (byte)((int)(l >>= 7) & 0x7F | 0x80);
        }
        int n2 = 9 - n;
        byteArrayOutputStream.write((byte[])object, n, n2);
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n = (bigInteger.bitLength() + 6) / 7;
        if (n == 0) {
            byteArrayOutputStream.write(0);
        } else {
            int n2;
            byte[] byArray = new byte[n];
            for (int k = n2 = (v5111) - 1; k >= 0; --k) {
                byArray[k] = (byte)(bigInteger.intValue() & 0x7F | 0x80);
                bigInteger = bigInteger.shiftRight(7);
            }
            byArray[n2] = (byte)(byArray[n2] & 0x7F);
            byteArrayOutputStream.write(byArray, 0, n);
        }
    }

    private void doOutput(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer;
        OIDTokenizer oIDTokenizer2 = oIDTokenizer;
        int n = Integer.parseInt(new OIDTokenizer(this.identifier).nextToken()) * 40;
        Object object = oIDTokenizer2.nextToken();
        if (((String)object).length() <= 18) {
            long l = n;
            this.writeField(byteArrayOutputStream, Long.parseLong((String)object) + l);
        } else {
            this.writeField(byteArrayOutputStream, new BigInteger((String)object).add(BigInteger.valueOf(n)));
        }
        while (oIDTokenizer2.hasMoreTokens()) {
            BigInteger bigInteger;
            String string = oIDTokenizer2.nextToken();
            if (string.length() <= 18) {
                long l = Long.parseLong(string);
                this.writeField(byteArrayOutputStream, l);
                continue;
            }
            object = bigInteger;
            bigInteger = new BigInteger(string);
            this.writeField(byteArrayOutputStream, (BigInteger)object);
        }
    }

    private synchronized byte[] getBody() {
        if (this.body == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            this.doOutput(new ByteArrayOutputStream());
            this.body = byteArrayOutputStream2.toByteArray();
        }
        return this.body;
    }

    private static boolean isValidBranchID(String string, int n) {
        int n2 = 0;
        int n3 = string.length();
        while ((n3 += -1) >= n) {
            char c2 = string.charAt(n3);
            if (c2 == '.') {
                if (n2 != 0 && (n2 <= 1 || string.charAt(n3 + 1) != '0')) {
                    n2 = 0;
                    continue;
                }
                return false;
            }
            if ('0' <= c2 && c2 <= '9') {
                ++n2;
                continue;
            }
            return false;
        }
        return n2 != 0 && (n2 <= 1 || string.charAt(n3 + 1) != '0');
        {
        }
    }

    private static boolean isValidIdentifier(String string) {
        if (string.length() >= 3 && string.charAt(1) == '.') {
            char c2 = string.charAt(0);
            if (c2 >= '0' && c2 <= '2') {
                return ASN1ObjectIdentifier.isValidBranchID(string, 2);
            }
            return false;
        }
        return false;
    }

    public static ASN1ObjectIdentifier fromOctetString(byte[] byArray) {
        OidHandle oidHandle;
        Object object = oidHandle;
        oidHandle = new OidHandle(byArray);
        if ((object = (ASN1ObjectIdentifier)pool.get(object)) == null) {
            return new ASN1ObjectIdentifier(byArray);
        }
        return object;
    }

    public String getId() {
        return this.identifier;
    }

    public ASN1ObjectIdentifier branch(String string) {
        return new ASN1ObjectIdentifier(this, string);
    }

    public boolean on(ASN1ObjectIdentifier object) {
        String string = ((ASN1ObjectIdentifier)((Object)string)).getId();
        object = ((ASN1ObjectIdentifier)object).getId();
        return string.length() > ((String)object).length() && string.charAt(((String)object).length()) == '.' && string.startsWith((String)object);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        int n = this.getBody().length;
        return StreamUtil.calculateBodyLength(n) + 1 + n;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((ASN1ObjectIdentifier)object).getBody();
        aSN1OutputStream.writeEncoded(bl, 6, (byte[])object);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive == this) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((ASN1ObjectIdentifier)aSN1Primitive).identifier);
    }

    public String toString() {
        return this.getId();
    }

    public ASN1ObjectIdentifier intern() {
        Object object;
        OidHandle oidHandle;
        Object object2 = oidHandle;
        oidHandle = new OidHandle(((ASN1ObjectIdentifier)object).getBody());
        ConcurrentMap<OidHandle, ASN1ObjectIdentifier> concurrentMap = pool;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)concurrentMap.get(object2);
        if (aSN1ObjectIdentifier == null) {
            if ((object2 = concurrentMap.putIfAbsent((OidHandle)object2, (ASN1ObjectIdentifier)object)) != null) {
                object = object2;
            }
        } else {
            object = aSN1ObjectIdentifier;
        }
        return object;
    }

    public static class OidHandle {
        private final int key;
        private final byte[] enc;

        public OidHandle(byte[] byArray) {
            this.key = Arrays.hashCode(byArray);
            this.enc = byArray;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object object) {
            if (object instanceof OidHandle) {
                return Arrays.areEqual(this.enc, ((OidHandle)object).enc);
            }
            return false;
        }
    }
}

